/**
 * Configuration module
 * Centralized configuration management
 */

const config = {
  server: {
    port: process.env.PORT || 3000,
    env: process.env.NODE_ENV || 'development'
  },
  api: {
    key: process.env.API_KEY,
    required: true
  }
};

function validateConfig() {
  const errors = [];

  if (!process.env.API_KEY || process.env.API_KEY.trim() === '') {
    errors.push('API_KEY is required in .env file');
  }

  config.api.key = process.env.API_KEY;

  if (errors.length > 0) {
    console.error('[Config] Configuration errors:');
    errors.forEach(error => console.error(`  - ${error}`));
    throw new Error('Invalid configuration');
  }

  return true;
}

module.exports = { config, validateConfig };

