const { Events, ActivityType, PresenceUpdateStatus } = require('discord.js');
const fs = require('fs');
const path = require('path');

module.exports = {
    name: Events.ClientReady,
    once: true,
    async execute(client) {
        console.log(`✅ Bot hazır! ${client.user.tag} olarak giriş yapıldı.`);
        console.log(`📊 ${client.guilds.cache.size} sunucuda aktif.`);
        console.log(`👥 ${client.users.cache.size} kullanıcıya hizmet veriyor.`);
        
        client.user.setPresence({
            activities: [{
                name: 'Eagle V | rovebots.com.tr',
                type: ActivityType.Watching
            }],
            status: PresenceUpdateStatus.DoNotDisturb
        });
        
        console.log('🔴 Bot durumu: Do Not Disturb (DND)');
        console.log('👀 Aktivite: RoveBot\'s');

        // Bot ses sistemi - otomatik ses odasına katılma
        try {
            const botSesPath = path.join(__dirname, '../botSesSistemi.json');
            
            if (fs.existsSync(botSesPath)) {
                const botSesData = JSON.parse(fs.readFileSync(botSesPath, 'utf8'));
                
                for (const [guildId, settings] of Object.entries(botSesData)) {
                    if (settings.enabled && settings.voiceChannelId) {
                        try {
                            const guild = client.guilds.cache.get(guildId);
                            if (guild) {
                                const voiceChannel = guild.channels.cache.get(settings.voiceChannelId);
                                if (voiceChannel && voiceChannel.isVoiceBased()) {
                                    const { joinVoiceChannel } = require('@discordjs/voice');
                                    
                                    const connection = joinVoiceChannel({
                                        channelId: voiceChannel.id,
                                        guildId: guild.id,
                                        adapterCreator: guild.voiceAdapterCreator,
                                        selfDeaf: true,  // Kulaklık kapalı
                                        selfMute: false  // Mikrofon açık
                                    });
                                    
                                    console.log(`🎵 ${guild.name} sunucusunda ${voiceChannel.name} ses odasına katıldı.`);
                                } else {
                                    console.log(`⚠️ ${guild.name} sunucusunda ses odası bulunamadı veya geçersiz.`);
                                }
                            }
                        } catch (voiceError) {
                            console.error(`❌ ${guildId} sunucusunda ses odasına katılırken hata:`, voiceError.message);
                        }
                    }
                }
            }
        } catch (error) {
            console.error('❌ Bot ses sistemi başlatılırken hata:', error);
        }
    },
};