const { Events } = require('discord.js');

module.exports = {
    name: Events.MessageUpdate,
    async execute(oldMessage, newMessage) {
        try {
            if (!newMessage || !newMessage.author) return;
            
            if (newMessage.author.bot) return;
            
            if (oldMessage.content === newMessage.content) return;
            
            if (newMessage.client.logSistemi && newMessage.client.logSistemi.isActive()) {
                await newMessage.client.logSistemi.logMessageUpdate(oldMessage, newMessage);
            }
        } catch (error) {
            console.error('Mesaj düzenleme log hatası:', error);
        }
    },
};