const { Events } = require('discord.js');

module.exports = {
    name: Events.MessageDelete,
    async execute(message) {
        try {
            if (!message || !message.author) return;
            
            if (message.author.bot) return;
            
            if (message.client.logSistemi && message.client.logSistemi.isActive()) {
                await message.client.logSistemi.logMessageDelete(message);
            }
        } catch (error) {
            console.error('Mesaj silme log hatası:', error);
        }
    },
};