const { Events } = require('discord.js');
const fs = require('fs');
const path = require('path');

module.exports = {
    name: Events.MessageCreate,
    async execute(message) {
        if (message.author.bot) return;

        if (message.client.kufurSistemi) {
            const kufurTespit = await message.client.kufurSistemi.processMessage(message);
            if (kufurTespit) {
                return;
            }
        }

        if (message.client.spamKoruma) {
            const spamTespit = await message.client.spamKoruma.checkSpam(message);
            if (spamTespit) {
                return;
            }
        }

        try {
            const icisimPath = path.join(__dirname, '../icisimSistemi.json');
            if (fs.existsSync(icisimPath)) {
                const icisimData = JSON.parse(fs.readFileSync(icisimPath, 'utf8'));
                const guildData = icisimData[message.guild.id];

                if (guildData && guildData.aktif && guildData.kanalId === message.channel.id) {
                    await message.react('✅');
                    await message.react('❌');
                }
            }
        } catch (error) {
            console.error('IC İsim reaction ekleme hatası:', error);
        }
        
    },
};