const { Events } = require('discord.js');

module.exports = {
    name: Events.InviteCreate,
    async execute(invite) {
        try {
            if (invite.client.inviteTracker) {
                await invite.client.inviteTracker.handleInviteCreate(invite);
            }

            if (invite.client.logSistemi && invite.client.logSistemi.isActive()) {
                await invite.client.logSistemi.logInviteCreate(invite);
            }
        } catch (error) {
            console.error('Davet oluşturma log hatası:', error);
        }
    },
};