const { Events } = require('discord.js');

module.exports = {
    name: Events.GuildMemberUpdate,
    async execute(oldMember, newMember) {
        try {
            if (newMember.client.logSistemi && newMember.client.logSistemi.isActive()) {
                await newMember.client.logSistemi.logRoleUpdate(oldMember, newMember);
                
                const oldTimeout = oldMember.communicationDisabledUntilTimestamp;
                const newTimeout = newMember.communicationDisabledUntilTimestamp;
                
                console.log(`Timeout kontrol: ${newMember.user.tag}`);
                console.log(`Eski timeout timestamp: ${oldTimeout}`);
                console.log(`Yeni timeout timestamp: ${newTimeout}`);
                
                if (!oldTimeout && newTimeout) {
                    const duration = newTimeout - Date.now();
                    console.log(`Timeout eklendi: ${newMember.user.tag}, Süre: ${duration}ms`);
                    await newMember.client.logSistemi.logTimeout(newMember, duration, null, null);
                }
                
                else if (oldTimeout && !newTimeout) {
                    console.log(`Timeout kaldırıldı: ${newMember.user.tag}`);
                    await newMember.client.logSistemi.logTimeoutRemove(newMember, null);
                }
                
                else if (oldTimeout && newTimeout && oldTimeout !== newTimeout) {
                    const duration = newTimeout - Date.now();
                    console.log(`Timeout süresi değişti: ${newMember.user.tag}, Yeni süre: ${duration}ms`);
                    await newMember.client.logSistemi.logTimeout(newMember, duration, null, null);
                }
            }
        } catch (error) {
            console.error('Üye güncelleme log hatası:', error);
        }
    },
};