const { Events, AuditLogEvent } = require('discord.js');

module.exports = {
    name: Events.GuildMemberRemove,
    async execute(member) {
        try {
            if (!member.client.logSistemi || !member.client.logSistemi.isActive()) {
                return;
            }

            try {
                const fetchedLogs = await member.guild.fetchAuditLogs({
                    limit: 1,
                    type: AuditLogEvent.MemberKick,
                });

                const kickLog = fetchedLogs.entries.first();

                if (kickLog) {
                    const { executor, target, createdTimestamp, reason } = kickLog;
                    
                    if (Date.now() - createdTimestamp <= 5000) {
                        if (target.id === member.id) {
                            console.log(`${member.user.tag} adlı kullanıcı ${executor.tag} tarafından atıldı.`);
                            await member.client.logSistemi.logKick(member, reason, executor);
                            return;
                        }
                    }
                }
            } catch (auditError) {
                console.error('Kick audit log kontrolü hatası:', auditError);
            }

            await member.client.logSistemi.logMemberLeave(member);
            
        } catch (error) {
            console.error('Üye çıkış log hatası:', error);
        }
    },
};