const { Events } = require('discord.js');
const fs = require('fs');
const path = require('path');

module.exports = {
    name: Events.GuildMemberAdd,
    async execute(member) {
        try {
            if (member.client.inviteTracker) {
                await member.client.inviteTracker.handleMemberJoin(member);
            }

            await handleAutoRole(member);

            if (member.client.logSistemi && member.client.logSistemi.isActive()) {
                await member.client.logSistemi.logMemberJoin(member);
            }
        } catch (error) {
            console.error('Giriş log hatası:', error);
        }
    },
};

async function handleAutoRole(member) {
    try {
        const otorolPath = path.join(__dirname, '../otorolSistemi.json');
        
        if (!fs.existsSync(otorolPath)) {
            return;
        }

        const otorolData = JSON.parse(fs.readFileSync(otorolPath, 'utf8'));
        const guildData = otorolData[member.guild.id];

        if (!guildData || !guildData.aktif || !guildData.rolId) {
            return;
        }

        const role = member.guild.roles.cache.get(guildData.rolId);
        if (!role) {
            console.error(`Otorol: ${guildData.rolId} ID'li rol bulunamadı`);
            return;
        }

        const botMember = member.guild.members.me;
        if (role.position >= botMember.roles.highest.position) {
            console.error(`Otorol: ${role.name} rolü bot rolünden yüksek konumda`);
            return;
        }

        await member.roles.add(role, 'Otomatik rol sistemi');

        guildData.istatistikler.toplamVerilen++;
        guildData.istatistikler.sonVerilen = Date.now();
        guildData.istatistikler.sonUye = member.id;

        fs.writeFileSync(otorolPath, JSON.stringify(otorolData, null, 4));

        if (member.client.logSistemi && member.client.logSistemi.isActive()) {
            await member.client.logSistemi.logAutoRole(member, role);
        }

        console.log(`Otorol: ${member.user.tag} kullanıcısına ${role.name} rolü verildi`);

    } catch (error) {
        console.error('Otorol hatası:', error);
    }
}