const { SlashCommandBuilder, EmbedBuilder, PermissionFlagsBits } = require('discord.js');
const fs = require('fs');
const path = require('path');

function checkPermission(interaction, requiredPermission) {
    // Null/undefined kontrolleri ekle
    if (!interaction || !interaction.guild || !interaction.member) {
        console.error('checkPermission: interaction, guild veya member undefined');
        return false;
    }

    const yetkiPath = path.join(__dirname, '../yetkiSistemi.json');
    
    if (!fs.existsSync(yetkiPath)) {
        const hasAdmin = interaction.member.permissions.has(PermissionFlagsBits.Administrator);
        console.log(`[checkPermission] yetkiSistemi.json bulunamadı, Administrator kontrolü: ${hasAdmin}`);
        return hasAdmin;
    }

    try {
        const yetkiData = JSON.parse(fs.readFileSync(yetkiPath, 'utf8'));
        const guildData = yetkiData[interaction.guild.id];

        if (!guildData || !guildData[requiredPermission]) {
            const hasAdmin = interaction.member.permissions.has(PermissionFlagsBits.Administrator);
            console.log(`[checkPermission] ${requiredPermission} yetkisi ayarlanmamış, Administrator kontrolü: ${hasAdmin}`);
            return hasAdmin;
        }

        const roleId = guildData[requiredPermission];
        const hasRole = interaction.member.roles.cache.has(roleId);
        const hasAdmin = interaction.member.permissions.has(PermissionFlagsBits.Administrator);
        const result = hasRole || hasAdmin;
        
        console.log(`[checkPermission] ${requiredPermission}:`, {
            roleId,
            hasRole,
            hasAdmin,
            result,
            userId: interaction.user.id,
            userRoles: interaction.member.roles.cache.map(r => r.id)
        });

        return result;
    } catch (error) {
        console.error('checkPermission JSON parse hatası:', error);
        return interaction.member.permissions.has(PermissionFlagsBits.Administrator);
    }
}

module.exports = {
    checkPermission,
    data: new SlashCommandBuilder()
        .setName('yetkiayarla')
        .setDescription('Tüm komutlar için yetki ayarlarını yönetir')
        .addStringOption(option =>
            option.setName('islem')
                .setDescription('Yapılacak işlem türü')
                .setRequired(true)
                .addChoices(
                    { name: 'Ban', value: 'ban' },
                    { name: 'Kick', value: 'kick' },
                    { name: 'Ban,Kick', value: 'ban,kick' },
                    { name: 'HerkeseRolVer', value: 'herkeserolver' },
                    { name: 'HerkestenRolAl', value: 'herkestenrolal' },
                    { name: 'Çekiliş Sorumlusu', value: 'cekilissorumlusu' },
                    { name: 'Ticket Sistemi Kurulum', value: 'ticketsistemikur' },
                    { name: 'Ticket Sistemi Yönetim', value: 'ticketsistemi' },
                    { name: 'Ticket Üye Yönetimi', value: 'ticketuye' },
                    { name: 'Spam Koruma', value: 'spamkoruma' },
                    { name: 'Ses Yönetimi', value: 'sesyonetimi' },
                    { name: 'Rol Yönetimi', value: 'rolyonetimi' },
                    { name: 'Oto Rol', value: 'otorol' },
                    { name: 'Mesaj Silme', value: 'mesajsil' },
                    { name: 'Log Güncelleme', value: 'logguncelle' },
                    { name: 'Küfür Engel', value: 'kufurengel' },
                    { name: 'Bot Ses Rolü', value: 'botses' },
                    { name: 'Sunucu Durum Embed', value: 'sunucudurumembed' },
                    { name: 'Sunucu Durum Komutu', value: 'sunucudurumkomutu' },
                    { name: 'Whitelist Komutu', value: 'whitelist' },
                    { name: 'Whitelist Ayarla', value: 'wlayarla' },
                    { name: 'IC İsim Ayarlama', value: 'icisimayarla' },
                    { name: 'IC İsim Onay Red', value: 'icisimonyared' },
                    { name: 'Rol Bilgi', value: 'rolbilgi' }
                ))
        .addStringOption(option =>
            option.setName('eylem')
                .setDescription('Yapılacak eylem')
                .setRequired(true)
                .addChoices(
                    { name: 'Ayarla', value: 'ayarla' },
                    { name: 'Kaldır', value: 'kaldir' },
                    { name: 'Görüntüle', value: 'goruntuele' }
                ))
        .addRoleOption(option =>
            option.setName('rol')
                .setDescription('Yetkili rol (boş bırakılırsa sadece Administrator yetkisi gerekir)')
                .setRequired(false)),

    async execute(interaction) {
        try {
            await interaction.deferReply();

            const islem = interaction.options.getString('islem');
            const rol = interaction.options.getRole('rol');
            const eylem = interaction.options.getString('eylem');

            const yetkiPath = path.join(__dirname, '../yetkiSistemi.json');
            let yetkiData = {};

            if (fs.existsSync(yetkiPath)) {
                yetkiData = JSON.parse(fs.readFileSync(yetkiPath, 'utf8'));
            }

            if (!yetkiData[interaction.guild.id]) {
                yetkiData[interaction.guild.id] = {
                    ban: null,
                    kick: null,
                    herkeserolver: null,
                    herkestenrolal: null,
                    cekilissorumlusu: null,
                    ticketsistemikur: null,
                    ticketsistemi: null,
                    ticketuye: null,
                    spamkoruma: null,
                    sesyonetimi: null,
                    rolyonetimi: null,
                    otorol: null,
                    mesajsil: null,
                    logguncelle: null,
                    kufurengel: null,
                    botses: null,
                    sunucudurumembed: null,
                    sunucudurumkomutu: null,
                    whitelist: null,
                    wlayarla: null,
                    icisimayarla: null,
                    icisimonyared: null,
                    rolbilgi: null
                };
            }

            const guildData = yetkiData[interaction.guild.id];

            if (eylem === 'goruntuele') {
                const embed = new EmbedBuilder()
                    .setColor(0x00ff00)
                    .setTitle('🔐 Yetki Ayarları')
                    .setDescription('Mevcut komut yetki ayarları:')
                    .addFields(
                        {
                            name: '🚫 Ban Yetkisi',
                            value: guildData.ban ? `<@&${guildData.ban}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '👢 Kick Yetkisi',
                            value: guildData.kick ? `<@&${guildData.kick}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '👥 HerkeseRolVer Yetkisi',
                            value: guildData.herkeserolver ? `<@&${guildData.herkeserolver}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '👤 HerkestenRolAl Yetkisi',
                            value: guildData.herkestenrolal ? `<@&${guildData.herkestenrolal}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '🎁 Çekiliş Sorumlusu Yetkisi',
                            value: guildData.cekilissorumlusu ? `<@&${guildData.cekilissorumlusu}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '🎫 Ticket Sistemi Kurulum',
                            value: guildData.ticketsistemikur ? `<@&${guildData.ticketsistemikur}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '🎫 Ticket Sistemi Yönetim',
                            value: guildData.ticketsistemi ? `<@&${guildData.ticketsistemi}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '👥 Ticket Üye Yönetimi',
                            value: guildData.ticketuye ? `<@&${guildData.ticketuye}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '🛡️ Spam Koruma',
                            value: guildData.spamkoruma ? `<@&${guildData.spamkoruma}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '🔊 Ses Yönetimi',
                            value: guildData.sesyonetimi ? `<@&${guildData.sesyonetimi}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '🎭 Rol Yönetimi',
                            value: guildData.rolyonetimi ? `<@&${guildData.rolyonetimi}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '🤖 Oto Rol',
                            value: guildData.otorol ? `<@&${guildData.otorol}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '🗑️ Mesaj Silme',
                            value: guildData.mesajsil ? `<@&${guildData.mesajsil}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '📝 Log Güncelleme',
                            value: guildData.logguncelle ? `<@&${guildData.logguncelle}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '🚫 Küfür Engel',
                            value: guildData.kufurengel ? `<@&${guildData.kufurengel}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '🎵 Bot Ses Rolü',
                            value: guildData.botses ? `<@&${guildData.botses}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '🖥️ Sunucu Durum Embed',
                            value: guildData.sunucudurumembed ? `<@&${guildData.sunucudurumembed}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '📊 Sunucu Durum Komutu',
                            value: guildData.sunucudurumkomutu ? `<@&${guildData.sunucudurumkomutu}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '🎫 Whitelist Komutu',
                            value: guildData.whitelist ? `<@&${guildData.whitelist}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '⚙️ Whitelist Ayarla',
                            value: guildData.wlayarla ? `<@&${guildData.wlayarla}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '📝 IC İsim Ayarlama',
                            value: guildData.icisimayarla ? `<@&${guildData.icisimayarla}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '✅ IC İsim Onay Red',
                            value: guildData.icisimonyared ? `<@&${guildData.icisimonyared}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        },
                        {
                            name: '🎭 Rol Bilgi',
                            value: guildData.rolbilgi ? `<@&${guildData.rolbilgi}>` : '❌ Ayarlanmamış (Sadece Administrator)',
                            inline: true
                        }
                    )
                    .setFooter({ text: `RoveBot\'s • Yetki Sistemi` })
                    .setTimestamp();

                return await interaction.editReply({ embeds: [embed] });
            }

            if (eylem === 'kaldir') {
                const islemler = islem.split(',');
                let kaldirilanlar = [];

                islemler.forEach(i => {
                    if (guildData[i.trim()]) {
                        guildData[i.trim()] = null;
                        kaldirilanlar.push(i.trim());
                    }
                });

                if (kaldirilanlar.length === 0) {
                    const errorEmbed = new EmbedBuilder()
                        .setColor(0xff0000)
                        .setTitle('❌ Hata')
                        .setDescription('Belirtilen işlemler için ayarlanmış yetki bulunamadı!')
                        .setTimestamp();

                    return await interaction.editReply({ embeds: [errorEmbed] });
                }

                fs.writeFileSync(yetkiPath, JSON.stringify(yetkiData, null, 2));

                const successEmbed = new EmbedBuilder()
                    .setColor(0x00ff00)
                    .setTitle('✅ Yetki Kaldırıldı')
                    .setDescription(`Aşağıdaki işlemler için yetki ayarları kaldırıldı:\n\n${kaldirilanlar.map(i => `• **${i.toUpperCase()}**`).join('\n')}`)
                    .addFields({
                        name: '📋 Not',
                        value: 'Artık bu işlemler sadece **Administrator** yetkisine sahip kullanıcılar tarafından kullanılabilir.',
                        inline: false
                    })
                    .setFooter({ text: `RoveBot\'s • Yetki Sistemi` })
                    .setTimestamp();

                return await interaction.editReply({ embeds: [successEmbed] });
            }

            if (eylem === 'ayarla') {
                if (!rol) {
                    const errorEmbed = new EmbedBuilder()
                        .setColor(0xff0000)
                        .setTitle('❌ Hata')
                        .setDescription('Yetki ayarlamak için bir rol belirtmelisiniz!')
                        .setTimestamp();

                    return await interaction.editReply({ embeds: [errorEmbed] });
                }

                const islemler = islem.split(',');
                let ayarlananlar = [];

                islemler.forEach(i => {
                    guildData[i.trim()] = rol.id;
                    ayarlananlar.push(i.trim());
                });

                fs.writeFileSync(yetkiPath, JSON.stringify(yetkiData, null, 2));

                const successEmbed = new EmbedBuilder()
                    .setColor(0x00ff00)
                    .setTitle('✅ Yetki Ayarlandı')
                    .setDescription(`**${rol.name}** rolü aşağıdaki işlemler için yetkilendirildi:`)
                    .addFields({
                        name: '🔐 Yetkili İşlemler',
                        value: ayarlananlar.map(i => `• **${i.toUpperCase()}**`).join('\n'),
                        inline: false
                    })
                    .addFields({
                        name: '👥 Yetkili Rol',
                        value: `<@&${rol.id}>`,
                        inline: true
                    })
                    .addFields({
                        name: '📋 Not',
                        value: 'Bu rol artık belirtilen işlemleri kullanabilir. Administrator yetkisi olan kullanıcılar her zaman bu komutları kullanabilir.',
                        inline: false
                    })
                    .setFooter({ text: `RoveBot\'s • Yetki Sistemi` })
                    .setTimestamp();

                return await interaction.editReply({ embeds: [successEmbed] });
            }

        } catch (error) {
            console.error('Yetkiayarla komutunda hata:', error);
            
            const errorEmbed = new EmbedBuilder()
                .setColor(0xff0000)
                .setTitle('❌ Sistem Hatası')
                .setDescription('Yetki ayarları güncellenirken bir hata oluştu!')
                .setTimestamp();

            if (interaction.deferred) {
                await interaction.editReply({ embeds: [errorEmbed] });
            } else {
                await interaction.reply({ embeds: [errorEmbed], ephemeral: true });
            }
        }
    }
};