const { SlashCommandBuilder, EmbedBuilder, PermissionFlagsBits } = require('discord.js');
const { checkPermission } = require('./yetkiayarla');
const fs = require('fs');
const path = require('path');

module.exports = {
    data: new SlashCommandBuilder()
        .setName('wl')
        .setDescription('Whitelist sistemini yönetir')
        .addStringOption(option =>
            option.setName('eylem')
                .setDescription('Yapılacak eylem')
                .setRequired(true)
                .addChoices(
                    { name: 'Ver', value: 'ver' },
                    { name: 'Al', value: 'al' }
                ))
        .addUserOption(option =>
            option.setName('kullanici')
                .setDescription('İşlem yapılacak kullanıcı')
                .setRequired(true)),

    async execute(interaction) {
        try {
            if (!checkPermission(interaction, 'whitelist')) {
                const errorEmbed = new EmbedBuilder()
                    .setColor(0xff0000)
                    .setTitle('❌ Yetkisiz Erişim')
                    .setDescription('Bu komutu kullanmak için Whitelist yetkisine sahip olmalısınız!')
                    .setTimestamp();

                return await interaction.reply({ embeds: [errorEmbed], ephemeral: true });
            }

            await interaction.deferReply();

            const eylem = interaction.options.getString('eylem');
            const kullanici = interaction.options.getUser('kullanici');
            const member = interaction.guild.members.cache.get(kullanici.id);

            if (!member) {
                const errorEmbed = new EmbedBuilder()
                    .setColor(0xff0000)
                    .setTitle('❌ Hata')
                    .setDescription('Kullanıcı bulunamadı!')
                    .setTimestamp();

                return await interaction.editReply({ embeds: [errorEmbed] });
            }

            const whitelistPath = path.join(__dirname, '../whitelistSistemi.json');
            let whitelistData = {};

            if (fs.existsSync(whitelistPath)) {
                whitelistData = JSON.parse(fs.readFileSync(whitelistPath, 'utf8'));
            }

            if (!whitelistData[interaction.guild.id]) {
                const errorEmbed = new EmbedBuilder()
                    .setColor(0xff0000)
                    .setTitle('❌ Hata')
                    .setDescription('Whitelist rolleri henüz ayarlanmamış! Lütfen önce `/wlayarla` komutunu kullanın.')
                    .setTimestamp();

                return await interaction.editReply({ embeds: [errorEmbed] });
            }

            const roller = whitelistData[interaction.guild.id].roller || [];
            
            if (roller.length === 0) {
                const errorEmbed = new EmbedBuilder()
                    .setColor(0xff0000)
                    .setTitle('❌ Hata')
                    .setDescription('Whitelist rolleri ayarlanmamış!')
                    .setTimestamp();

                return await interaction.editReply({ embeds: [errorEmbed] });
            }

            const successEmbed = new EmbedBuilder()
                .setColor(0x00ff00)
                .setTimestamp();

            if (eylem === 'ver') {
                let verilenRoller = [];
                let zatenVar = [];

                for (const rolId of roller) {
                    const rol = interaction.guild.roles.cache.get(rolId);
                    if (rol) {
                        if (member.roles.cache.has(rolId)) {
                            zatenVar.push(`<@&${rolId}>`);
                        } else {
                            await member.roles.add(rolId);
                            verilenRoller.push(`<@&${rolId}>`);
                        }
                    }
                }

                if (verilenRoller.length === 0) {
                    const errorEmbed = new EmbedBuilder()
                        .setColor(0xffaa00)
                        .setTitle('⚠️ Bilgi')
                        .setDescription(`${kullanici} kullanıcısı zaten whitelist rollerine sahip!`)
                        .addFields({
                            name: '🔄 Mevcut Roller',
                            value: zatenVar.join('\n') || 'Bilinmiyor',
                            inline: false
                        })
                        .setTimestamp();

                    return await interaction.editReply({ embeds: [errorEmbed] });
                }

                successEmbed
                    .setTitle('✅ Whitelist Verildi')
                    .setDescription(`${kullanici} kullanıcısına whitelist roller verildi!`)
                    .addFields({
                        name: '👤 Kullanıcı',
                        value: `${kullanici} (${kullanici.id})`,
                        inline: true
                    })
                    .addFields({
                        name: '✅ Verilen Roller',
                        value: verilenRoller.join('\n'),
                        inline: false
                    });

                if (zatenVar.length > 0) {
                    successEmbed.addFields({
                        name: 'ℹ️ Zaten Mevcut',
                        value: zatenVar.join('\n'),
                        inline: false
                    });
                }

                successEmbed.addFields({
                    name: '👮 İşlem Yapan',
                    value: `${interaction.user} (${interaction.user.id})`,
                    inline: true
                });

            } else if (eylem === 'al') {
                let alinanRoller = [];
                let rolYok = [];

                for (const rolId of roller) {
                    const rol = interaction.guild.roles.cache.get(rolId);
                    if (rol) {
                        if (member.roles.cache.has(rolId)) {
                            await member.roles.remove(rolId);
                            alinanRoller.push(`<@&${rolId}>`);
                        } else {
                            rolYok.push(`<@&${rolId}>`);
                        }
                    }
                }

                if (alinanRoller.length === 0) {
                    const errorEmbed = new EmbedBuilder()
                        .setColor(0xffaa00)
                        .setTitle('⚠️ Bilgi')
                        .setDescription(`${kullanici} kullanıcısı zaten whitelist rollerine sahip değil!`)
                        .setTimestamp();

                    return await interaction.editReply({ embeds: [errorEmbed] });
                }

                successEmbed
                    .setTitle('✅ Whitelist Alındı')
                    .setDescription(`${kullanici} kullanıcısından whitelist roller alındı!`)
                    .addFields({
                        name: '👤 Kullanıcı',
                        value: `${kullanici} (${kullanici.id})`,
                        inline: true
                    })
                    .addFields({
                        name: '❌ Alınan Roller',
                        value: alinanRoller.join('\n'),
                        inline: false
                    })
                    .addFields({
                        name: '👮 İşlem Yapan',
                        value: `${interaction.user} (${interaction.user.id})`,
                        inline: true
                    });
            }

            successEmbed.setFooter({ text: 'RoveBot\'s • Whitelist Sistemi' });

            await interaction.editReply({ embeds: [successEmbed] });

            // Log gönder
            try {
                const configPath = path.join(__dirname, '../../config.json');
                const config = JSON.parse(fs.readFileSync(configPath, 'utf8'));
                
                if (config.LogSistemi.aktif && config.LogSistemi.logKanallari.wlLog) {
                    const logChannel = interaction.guild.channels.cache.get(config.LogSistemi.logKanallari.wlLog);
                    if (logChannel) {
                        const logEmbed = new EmbedBuilder()
                            .setColor(eylem === 'ver' ? 0x00ff00 : 0xff0000)
                            .setTitle(`🎫 Whitelist ${eylem === 'ver' ? 'Verildi' : 'Alındı'}`)
                            .setDescription(`Whitelist işlemi gerçekleştirildi`)
                            .addFields({
                                name: '👤 Kullanıcı',
                                value: `${kullanici} (${kullanici.id})`,
                                inline: true
                            })
                            .addFields({
                                name: '👮 İşlem Yapan',
                                value: `${interaction.user} (${interaction.user.id})`,
                                inline: true
                            })
                            .addFields({
                                name: '📋 Eylem',
                                value: eylem === 'ver' ? '✅ Whitelist Verildi' : '❌ Whitelist Alındı',
                                inline: true
                            })
                            .setThumbnail(kullanici.displayAvatarURL({ dynamic: true }))
                            .setFooter({ text: 'RoveBot\'s • Log Sistemi' })
                            .setTimestamp();

                        await logChannel.send({ embeds: [logEmbed] });
                    }
                }
            } catch (logError) {
                console.error('Log gönderme hatası:', logError);
            }

        } catch (error) {
            console.error('WL komutu hatası:', error);
            
            const errorEmbed = new EmbedBuilder()
                .setColor(0xff0000)
                .setTitle('❌ Sistem Hatası')
                .setDescription('Whitelist işlemi sırasında bir hata oluştu!')
                .setTimestamp();

            if (interaction.deferred) {
                await interaction.editReply({ embeds: [errorEmbed] });
            } else {
                await interaction.reply({ embeds: [errorEmbed], ephemeral: true });
            }
        }
    }
};