const { SlashCommandBuilder, EmbedBuilder } = require('discord.js');
const packageJson = require('../../package.json');

module.exports = {
    data: new SlashCommandBuilder()
        .setName('version')
        .setDescription('Bot sürüm bilgilerini ve sistem detaylarını gösterir.'),
    
    async execute(interaction) {
        const botVersion = packageJson.version;
        const discordJsVersion = packageJson.dependencies['discord.js'].replace('^', '');
        const nodeVersion = process.version;
        const uptime = process.uptime();
        
        const days = Math.floor(uptime / 86400);
        const hours = Math.floor((uptime % 86400) / 3600);
        const minutes = Math.floor((uptime % 3600) / 60);
        const seconds = Math.floor(uptime % 60);
        
        let uptimeString = '';
        if (days > 0) uptimeString += `${days}g `;
        if (hours > 0) uptimeString += `${hours}s `;
        if (minutes > 0) uptimeString += `${minutes}d `;
        uptimeString += `${seconds}sn`;
        
        const memoryUsage = process.memoryUsage();
        const memoryUsed = Math.round(memoryUsage.heapUsed / 1024 / 1024);
        const memoryTotal = Math.round(memoryUsage.heapTotal / 1024 / 1024);
        
        const versionEmbed = new EmbedBuilder()
            .setColor(0x7289da)
            .setTitle('🤖 RoveBot\'s Bot - Sürüm Bilgileri')
            .setDescription('Bot ve sistem detayları')
            .addFields(
                {
                    name: '📦 Bot Sürümü',
                    value: `\`v${botVersion}\``,
                    inline: true
                },
                {
                    name: '🔧 Discord.js',
                    value: `\`v${discordJsVersion}\``,
                    inline: true
                },
                {
                    name: '🟢 Node.js',
                    value: `\`${nodeVersion}\``,
                    inline: true
                },
                {
                    name: '⏱️ Çalışma Süresi',
                    value: `\`${uptimeString}\``,
                    inline: true
                },
                {
                    name: '💾 Bellek Kullanımı',
                    value: `\`${memoryUsed}MB / ${memoryTotal}MB\``,
                    inline: true
                },
                {
                    name: '📊 Sunucu Sayısı',
                    value: `\`${interaction.client.guilds.cache.size}\``,
                    inline: true
                },
                {
                    name: '👥 Kullanıcı Sayısı',
                    value: `\`${interaction.client.users.cache.size}\``,
                    inline: true
                },
                {
                    name: '🏓 Ping',
                    value: `\`${interaction.client.ws.ping}ms\``,
                    inline: true
                },
                {
                    name: '🌐 Keep Alive',
                    value: '✅ Aktif',
                    inline: true
                }
            )
            .setFooter({ 
                text: `${interaction.user.tag} tarafından istendi`, 
                iconURL: interaction.user.displayAvatarURL() 
            })
            .setTimestamp();

        await interaction.reply({ 
            embeds: [versionEmbed] 
        });
    },
};