const { SlashCommandBuilder, EmbedBuilder, PermissionFlagsBits } = require('discord.js');
const { checkPermission } = require('./yetkiayarla');
const LogSistemi = require('../logSistemi');
const fs = require('fs');
const path = require('path');

module.exports = {
    data: new SlashCommandBuilder()
        .setName('sunucudurumembed')
        .setDescription('Sunucu durum embed ayarlarını yapılandırır')
        .addStringOption(option =>
            option.setName('eylem')
                .setDescription('Yapılacak işlem')
                .setRequired(true)
                .addChoices(
                    { name: 'Ayarla', value: 'ayarla' },
                    { name: 'Görüntüle', value: 'goruntuele' }
                ))
        .addStringOption(option =>
            option.setName('ipadresi')
                .setDescription('Sunucu IP adresi (boş bırakılırsa "GIZLI" olarak gösterilir)')
                .setRequired(false))
        .addStringOption(option =>
            option.setName('cfxlink')
                .setDescription('CFX sunucu linki (sunucuya bağlan butonu için gerekli)')
                .setRequired(false))
        .addStringOption(option =>
            option.setName('ticketodaid')
                .setDescription('Ticket oda ID\'si')
                .setRequired(false)),

    async execute(interaction) {
        try {
            if (!checkPermission(interaction, 'sunucudurumembed')) {
                const errorEmbed = new EmbedBuilder()
                    .setColor(0xff0000)
                    .setTitle('❌ Yetkisiz Erişim')
                    .setDescription('Bu komutu kullanmak için Sunucu Durum Embed yetkisine sahip olmalısınız!')
                    .setTimestamp();

                return await interaction.reply({ embeds: [errorEmbed], ephemeral: true });
            }

            await interaction.deferReply();

            const eylem = interaction.options.getString('eylem');
            const configPath = path.join(__dirname, '../../config.json');
            const config = JSON.parse(fs.readFileSync(configPath, 'utf8'));

            if (!config.SunucuDurum) {
                config.SunucuDurum = {
                    aktif: false,
                    ipAdresi: 'gizli',
                    cfxLink: '',
                    ticketOdaId: '',
                    embedKanalId: '',
                    embedMesajId: '',
                    durum: 'Aktif'
                };
            }

            if (eylem === 'goruntuele') {
                const embed = new EmbedBuilder()
                    .setColor('#0099ff')
                    .setTitle('🖥️ Sunucu Durum Embed Ayarları')
                    .setDescription('Mevcut sunucu durum embed ayarları:')
                    .addFields(
                        {
                            name: '🌐 IP Adresi',
                            value: config.SunucuDurum.ipAdresi === 'gizli' ? '🔒 GIZLI' : `\`${config.SunucuDurum.ipAdresi}\``,
                            inline: true
                        },
                        {
                            name: '🔗 CFX Link',
                            value: config.SunucuDurum.cfxLink || '❌ Ayarlanmamış',
                            inline: true
                        },
                        {
                            name: '🎫 Ticket Oda ID',
                            value: config.SunucuDurum.ticketOdaId ? `<#${config.SunucuDurum.ticketOdaId}>` : '❌ Ayarlanmamış',
                            inline: true
                        },
                        {
                            name: '📊 Mevcut Durum',
                            value: config.SunucuDurum.durum || 'Aktif',
                            inline: true
                        },
                        {
                            name: '📍 Embed Kanalı',
                            value: config.SunucuDurum.embedKanalId ? `<#${config.SunucuDurum.embedKanalId}>` : '❌ Ayarlanmamış',
                            inline: true
                        },
                        {
                            name: '🔧 Sistem Durumu',
                            value: config.SunucuDurum.aktif ? '✅ Aktif' : '❌ Pasif',
                            inline: true
                        }
                    )
                    .setFooter({ text: 'RoveBot\'s • Sunucu Durum Sistemi' })
                    .setTimestamp();

                return await interaction.editReply({ embeds: [embed] });
            }

            if (eylem === 'ayarla') {
                const ipAdresi = interaction.options.getString('ipadresi');
                const cfxLink = interaction.options.getString('cfxlink');
                const ticketOdaId = interaction.options.getString('ticketodaid');

                if (!cfxLink) {
                    const errorEmbed = new EmbedBuilder()
                        .setColor(0xff0000)
                        .setTitle('❌ Eksik Bilgi')
                        .setDescription('CFX sunucu linki zorunludur! Sunucuya bağlan butonu için gereklidir.\n\n**Örnek:** `fivem://connect/127.0.0.1:30120`')
                        .setTimestamp();

                    return await interaction.editReply({ embeds: [errorEmbed] });
                }

                // Ticket oda ID kontrolü
                if (ticketOdaId) {
                    const ticketChannel = interaction.guild.channels.cache.get(ticketOdaId);
                    if (!ticketChannel) {
                        const errorEmbed = new EmbedBuilder()
                            .setColor(0xff0000)
                            .setTitle('❌ Geçersiz Kanal')
                            .setDescription('Belirtilen ticket oda ID\'si geçerli bir kanal değil!')
                            .setTimestamp();

                        return await interaction.editReply({ embeds: [errorEmbed] });
                    }
                }

                // Ayarları güncelle
                config.SunucuDurum.ipAdresi = ipAdresi || 'gizli';
                config.SunucuDurum.cfxLink = cfxLink;
                config.SunucuDurum.ticketOdaId = ticketOdaId || '';
                config.SunucuDurum.aktif = true;

                fs.writeFileSync(configPath, JSON.stringify(config, null, 4));

                const successEmbed = new EmbedBuilder()
                    .setColor('#00ff00')
                    .setTitle('✅ Sunucu Durum Embed Ayarlandı')
                    .setDescription('Sunucu durum embed ayarları başarıyla güncellendi!')
                    .addFields(
                        {
                            name: '🌐 IP Adresi',
                            value: config.SunucuDurum.ipAdresi === 'gizli' ? '🔒 GIZLI (Kullanıcılara gizli gösterilecek)' : `\`${config.SunucuDurum.ipAdresi}\``,
                            inline: false
                        },
                        {
                            name: '🔗 CFX Link',
                            value: `\`${cfxLink}\``,
                            inline: false
                        },
                        {
                            name: '🎫 Ticket Oda',
                            value: ticketOdaId ? `<#${ticketOdaId}>` : '❌ Ayarlanmadı',
                            inline: false
                        }
                    )
                    .addFields({
                        name: '📋 Sonraki Adım',
                        value: 'Artık `/sunucudurum` komutunu kullanarak sunucu durumunu güncelleyebilirsiniz.',
                        inline: false
                    })
                    .setFooter({ text: 'RoveBot\'s • Sunucu Durum Sistemi' })
                    .setTimestamp();

                await interaction.editReply({ embeds: [successEmbed] });

                // Log kaydı
                if (interaction.client.logSistemi) {
                    const logSistemi = interaction.client.logSistemi;
                    await logSistemi.logSunucuDurumEmbed(
                        interaction.guild.id,
                        interaction.user,
                        {
                            ipAddress: config.SunucuDurum.ipAdresi,
                            cfxLink: cfxLink,
                            ticketRoomId: ticketOdaId
                        }
                    );
                }
            }

        } catch (error) {
            console.error('Sunucudurumembed komutu hatası:', error);
            
            const errorEmbed = new EmbedBuilder()
                .setTitle('❌ Hata Oluştu')
                .setDescription(`Sunucu durum embed ayarları güncellenirken bir hata oluştu:\n\`\`\`${error.message}\`\`\``)
                .setColor('#ff0000')
                .setTimestamp();

            if (interaction.deferred) {
                await interaction.editReply({ embeds: [errorEmbed] });
            } else {
                await interaction.reply({ embeds: [errorEmbed], ephemeral: true });
            }
        }
    }
};