const { SlashCommandBuilder, EmbedBuilder } = require('discord.js');

module.exports = {
    data: new SlashCommandBuilder()
        .setName('sunucubilgi')
        .setDescription('Sunucu hakkında detaylı bilgi gösterir'),

    async execute(interaction) {
        try {
            const guild = interaction.guild;
            
            // Guild bilgilerini al
            const guildName = guild.name;
            const guildIcon = guild.iconURL({ dynamic: true, size: 1024 });
            const guildBanner = guild.bannerURL({ dynamic: true, size: 1024 });
            const memberCount = guild.memberCount;
            const boostCount = guild.premiumSubscriptionCount || 0;
            const boostLevel = guild.premiumTier;
            const createdAt = guild.createdAt;
            const ownerId = guild.ownerId;
            const owner = await guild.members.fetch(ownerId).catch(() => null);
            
            // Kanal sayıları
            const textChannels = guild.channels.cache.filter(channel => channel.type === 0).size;
            const voiceChannels = guild.channels.cache.filter(channel => channel.type === 2).size;
            const categories = guild.channels.cache.filter(channel => channel.type === 4).size;
            
            // Rol sayısı
            const roleCount = guild.roles.cache.size;
            
            // Emoji sayısı
            const emojiCount = guild.emojis.cache.size;
            
            // Verification level
            const verificationLevels = {
                0: 'Yok',
                1: 'Düşük',
                2: 'Orta',
                3: 'Yüksek',
                4: 'Çok Yüksek'
            };
            const verificationLevel = verificationLevels[guild.verificationLevel] || 'Bilinmiyor';
            
            // Boost level emojileri
            const boostEmojis = {
                0: '📊',
                1: '📈',
                2: '📊',
                3: '🚀'
            };
            
            const embed = new EmbedBuilder()
                .setTitle(`📋 ${guildName} - Sunucu Bilgileri`)
                .setThumbnail(guildIcon)
                .setImage(guildBanner)
                .addFields(
                    {
                        name: '🏷️ Sunucu Adı',
                        value: guildName,
                        inline: true
                    },
                    {
                        name: '👑 Sunucu Sahibi',
                        value: owner ? `<@${ownerId}>` : 'Bilinmiyor',
                        inline: true
                    },
                    {
                        name: '📅 Oluşturulma Tarihi',
                        value: `<t:${Math.floor(createdAt.getTime() / 1000)}:F>`,
                        inline: true
                    },
                    {
                        name: '👥 Toplam Üye',
                        value: `${memberCount.toLocaleString('tr-TR')} üye`,
                        inline: true
                    },
                    {
                        name: `${boostEmojis[boostLevel]} Boost Bilgileri`,
                        value: `**Seviye:** ${boostLevel}\n**Boost Sayısı:** ${boostCount}`,
                        inline: true
                    },
                    {
                        name: '🔒 Güvenlik Seviyesi',
                        value: verificationLevel,
                        inline: true
                    },
                    {
                        name: '📺 Kanallar',
                        value: `**Metin:** ${textChannels}\n**Ses:** ${voiceChannels}\n**Kategori:** ${categories}`,
                        inline: true
                    },
                    {
                        name: '🎭 Roller',
                        value: `${roleCount} rol`,
                        inline: true
                    },
                    {
                        name: '😀 Emojiler',
                        value: `${emojiCount} emoji`,
                        inline: true
                    }
                )
                .setColor('#0099ff')
                .setTimestamp()
                .setFooter({
                    text: `Sunucu ID: ${guild.id}`,
                    iconURL: guildIcon
                });

            await interaction.reply({ embeds: [embed] });

        } catch (error) {
            console.error('Sunucu bilgi hatası:', error);
            await interaction.reply({
                content: '❌ Sunucu bilgileri alınırken bir hata oluştu!',
                ephemeral: true
            });
        }
    }
};