const { SlashCommandBuilder, EmbedBuilder, PermissionFlagsBits } = require('discord.js');
const config = require('../../config.json');
const { checkPermission } = require('./yetkiayarla');

module.exports = {
    data: new SlashCommandBuilder()
        .setName('spamkoruma')
        .setDescription('Spam koruma sistemini yönetir.')
        .addStringOption(option =>
            option.setName('islem')
                .setDescription('Yapılacak işlem')
                .setRequired(true)
                .addChoices(
                    { name: '🟢 Sistemi Aç', value: 'ac' },
                    { name: '🔴 Sistemi Kapat', value: 'kapat' },
                    { name: '📊 Sistem Durumu', value: 'durum' },
                    { name: '📈 İstatistikler', value: 'istatistik' },
                    { name: '🧹 Geçmiş Temizle', value: 'temizle' },
                    { name: '⚙️ Ayarlar', value: 'ayarlar' }
                ))
        .addUserOption(option =>
            option.setName('kullanici')
                .setDescription('Kullanıcı işlemleri için (opsiyonel)')
                .setRequired(false)),
    
    async execute(interaction) {
        if (!checkPermission(interaction, 'spamkoruma')) {
            const errorEmbed = new EmbedBuilder()
                .setColor(0xff0000)
                .setTitle('❌ Yetkisiz Erişim')
                .setDescription('Bu komutu kullanmak için Spam Koruma yetkisine sahip olmalısınız!')
                .setTimestamp();

            return await interaction.reply({ embeds: [errorEmbed], ephemeral: true });
        }

        const islem = interaction.options.getString('islem');
        const kullanici = interaction.options.getUser('kullanici');
        const spamKoruma = interaction.client.spamKoruma;
        
        if (!spamKoruma) {
            const errorEmbed = new EmbedBuilder()
                .setColor(0xff0000)
                .setTitle('❌ Sistem Hatası')
                .setDescription('Spam koruma sistemi başlatılamadı.')
                .setTimestamp();
            
            return await interaction.reply({ embeds: [errorEmbed], ephemeral: true });
        }
        
        switch (islem) {
            case 'ac':
                spamKoruma.toggleSystem(true);
                const acEmbed = new EmbedBuilder()
                    .setColor(0x00ff00)
                    .setTitle('🟢 Spam Koruma Aktifleştirildi')
                    .setDescription('Spam koruma sistemi başarıyla aktifleştirildi.')
                    .addFields(
                        {
                            name: '⚙️ Aktif Özellikler',
                            value: '• Otomatik spam tespiti\n• Mesaj silme\n• DM uyarı sistemi\n• Kanal uyarıları\n• Detaylı loglama'
                        },
                        {
                            name: '📊 Spam Limitleri',
                            value: `• **${config.SpamKoruma.esikDegeri.mesajSayisi}** mesaj\n• **${config.SpamKoruma.esikDegeri.zaman / 1000}** saniye içinde\n• İstisnalı roller korunur`
                        }
                    )
                    .setFooter({ text: `RoveBot\'s • Spam Koruma Sistemi` })
                    .setTimestamp();
                
                await interaction.reply({ embeds: [acEmbed] });
                break;
                
            case 'kapat':
                spamKoruma.toggleSystem(false);
                const kapatEmbed = new EmbedBuilder()
                    .setColor(0xff0000)
                    .setTitle('🔴 Spam Koruma Devre Dışı')
                    .setDescription('Spam koruma sistemi devre dışı bırakıldı.')
                    .addFields({
                        name: '⚠️ Uyarı',
                        value: 'Sistem kapalıyken spam kontrolü yapılmayacak ve mesajlar silinmeyecektir.'
                    })
                    .setFooter({ text: `RoveBot\'s • Spam Koruma Sistemi` })
                    .setTimestamp();
                
                await interaction.reply({ embeds: [kapatEmbed] });
                break;
                
            case 'durum':
                const sistemAktif = spamKoruma.isActive();
                const durumEmbed = new EmbedBuilder()
                    .setColor(sistemAktif ? 0x00ff00 : 0xff0000)
                    .setTitle('📊 Spam Koruma Durumu')
                    .setDescription(`Sistem şu anda **${sistemAktif ? 'AKTİF' : 'KAPALI'}**`)
                    .addFields(
                        {
                            name: '⚙️ Sistem Bilgileri',
                            value: `• Durum: ${sistemAktif ? '🟢 Aktif' : '🔴 Kapalı'}\n• Mesaj Limiti: ${config.SpamKoruma.esikDegeri.mesajSayisi}\n• Zaman Limiti: ${config.SpamKoruma.esikDegeri.zaman / 1000}s\n• İstisnalı Roller: ${config.SpamKoruma.istisnaliRoller.length}`,
                            inline: true
                        },
                        {
                            name: '📋 Ayarlar',
                            value: `• Log Kanalı: ${config.SpamKoruma.spamlogchannelid !== 'SPAM_LOG_KANAL_ID_BURAYA' ? '✅ Ayarlandı' : '❌ Ayarlanmadı'}\n• DM Uyarıları: ✅ Aktif\n• Kanal Uyarıları: ✅ Aktif\n• Otomatik Temizlik: ✅ Aktif`,
                            inline: true
                        }
                    )
                    .setFooter({ text: `RoveBot\'s • Küfür Engel Sistemi` })
                    .setTimestamp();
                
                await interaction.reply({ embeds: [durumEmbed] });
                break;
                
            case 'istatistik':
                if (kullanici) {
                    const userStats = spamKoruma.getUserStats(kullanici.id);
                    const userEmbed = new EmbedBuilder()
                        .setColor(0x7289da)
                        .setTitle('👤 Kullanıcı Spam İstatistikleri')
                        .setDescription(`**${kullanici.tag}** için spam istatistikleri`)
                        .addFields(
                            {
                                name: '📊 Mesaj Bilgileri',
                                value: `• Toplam Mesaj: **${userStats.toplamMesaj}**\n• Son 24 Saat: **${userStats.son24SaatMesaj}**\n• Spam Durumu: ${userStats.aktifSpamDurumu ? '🔴 Risk' : '🟢 Normal'}`,
                                inline: true
                            }
                        )
                        .setThumbnail(kullanici.displayAvatarURL())
                        .setFooter({ text: `RoveBot\'s • Küfür Engel Sistemi` })
                        .setTimestamp();
                    
                    if (userStats.sonMesajZamani) {
                        userEmbed.addFields({
                            name: '🕒 Son Mesaj',
                            value: `<t:${Math.floor(userStats.sonMesajZamani.getTime() / 1000)}:R>`,
                            inline: true
                        });
                    }
                    
                    await interaction.reply({ embeds: [userEmbed] });
                } else {
                    const systemStats = spamKoruma.getSystemStats();
                    const statsEmbed = new EmbedBuilder()
                        .setColor(0x7289da)
                        .setTitle('📈 Spam Koruma İstatistikleri')
                        .setDescription('Spam koruma sistemi genel istatistikleri')
                        .addFields(
                            {
                                name: '👥 Kullanıcı Verileri',
                                value: `• Kayıtlı Kullanıcı: **${systemStats.toplamKullanici}**\n• Toplam Spam: **${systemStats.toplamSpam}**\n• Bugünkü Spam: **${systemStats.bugunkuSpam}**`,
                                inline: true
                            },
                            {
                                name: '🛡️ Sistem Durumu',
                                value: `• Durum: ${systemStats.sistemAktif ? '🟢 Aktif' : '🔴 Kapalı'}\n• İstisnalı Roller: **${systemStats.istisnaliRolSayisi}**\n• Uptime: <t:${Math.floor((Date.now() - process.uptime() * 1000) / 1000)}:R>`,
                                inline: true
                            },
                            {
                                name: '⚙️ Sistem Ayarları',
                                value: `• Mesaj Limiti: **${systemStats.esikDegeri.mesajSayisi}**\n• Zaman Limiti: **${systemStats.esikDegeri.zaman / 1000}** saniye\n• Otomatik Temizlik: ✅ Aktif`,
                                inline: false
                            }
                        )
                        .setFooter({ text: `RoveBot\'s • Küfür Engel Sistemi` })
                        .setTimestamp();
                    
                    await interaction.reply({ embeds: [statsEmbed] });
                }
                break;
                
            case 'temizle':
                if (kullanici) {
                    spamKoruma.clearUserHistory(kullanici.id);
                    const temizleUserEmbed = new EmbedBuilder()
                        .setColor(0x00ff00)
                        .setTitle('🧹 Kullanıcı Geçmişi Temizlendi')
                        .setDescription(`**${kullanici.tag}** kullanıcısının spam geçmişi temizlendi.`)
                        .setFooter({ text: `RoveBot\'s • Spam Koruma Sistemi` })
                        .setTimestamp();
                    
                    await interaction.reply({ embeds: [temizleUserEmbed] });
                } else {
                    spamKoruma.clearUserHistory();
                    const temizleAllEmbed = new EmbedBuilder()
                        .setColor(0x00ff00)
                        .setTitle('🧹 Tüm Geçmiş Temizlendi')
                        .setDescription('Tüm kullanıcıların spam geçmişi temizlendi.')
                        .addFields({
                            name: '⚠️ Uyarı',
                            value: 'Bu işlem geri alınamaz. Tüm spam kayıtları silinmiştir.'
                        })
                        .setFooter({ text: `RoveBot\'s • Spam Koruma Sistemi` })
                        .setTimestamp();
                    
                    await interaction.reply({ embeds: [temizleAllEmbed] });
                }
                break;
                
            case 'ayarlar':
                const ayarlarEmbed = new EmbedBuilder()
                    .setColor(0x7289da)
                    .setTitle('⚙️ Spam Koruma Ayarları')
                    .setDescription('Mevcut sistem ayarları ve yapılandırma bilgileri')
                    .addFields(
                        {
                            name: '📊 Spam Limitleri',
                            value: `• **Mesaj Sayısı:** ${config.SpamKoruma.esikDegeri.mesajSayisi}\n• **Zaman Aralığı:** ${config.SpamKoruma.esikDegeri.zaman / 1000} saniye\n• **Hesaplama:** ${config.SpamKoruma.esikDegeri.mesajSayisi} mesaj/${config.SpamKoruma.esikDegeri.zaman / 1000}s`,
                            inline: true
                        },
                        {
                            name: '🛡️ İstisnalı Roller',
                            value: config.SpamKoruma.istisnaliRoller.length > 0 
                                ? config.SpamKoruma.istisnaliRoller.map(roleId => `<@&${roleId}>`).join('\n')
                                : 'Henüz istisnalı rol eklenmemiş',
                            inline: true
                        },
                        {
                            name: '📝 Log Ayarları',
                            value: `• **Log Kanalı:** ${config.SpamKoruma.spamlogchannelid !== 'SPAM_LOG_KANAL_ID_BURAYA' ? `<#${config.SpamKoruma.spamlogchannelid}>` : '❌ Ayarlanmamış'}\n• **DM Uyarıları:** ✅ Aktif\n• **Kanal Uyarıları:** ✅ Aktif`,
                            inline: false
                        },
                        {
                            name: '🔧 Yapılandırma',
                            value: '`config.json` dosyasındaki `SpamKoruma` bölümünden ayarları değiştirebilirsiniz.',
                            inline: false
                        }
                    )
                    .setFooter({ text: `RoveBot\'s • Küfür Engel Sistemi` })
                    .setTimestamp();
                
                await interaction.reply({ embeds: [ayarlarEmbed] });
                break;
                
            default:
                const defaultEmbed = new EmbedBuilder()
                    .setColor(0xff0000)
                    .setTitle('❌ Geçersiz İşlem')
                    .setDescription('Lütfen geçerli bir işlem seçin.')
                    .setTimestamp();
                
                await interaction.reply({ embeds: [defaultEmbed], ephemeral: true });
        }
    },
};