const { SlashCommandBuilder, EmbedBuilder, PermissionFlagsBits, ChannelType } = require('discord.js');
const fs = require('fs');
const path = require('path');

module.exports = {
    data: new SlashCommandBuilder()
        .setName('setuplog')
        .setDescription('Log sistemini kurar ve tüm log kanallarını oluşturur')
        .addRoleOption(option =>
            option.setName('ownerrolu')
                .setDescription('Sunucu sahibi rolü - Tüm log kanallarında tam yetki')
                .setRequired(true))
        .addRoleOption(option =>
            option.setName('kufuryoneticirolu')
                .setDescription('Küfür loglarını yönetecek yetkili rolü')
                .setRequired(true))
        .addRoleOption(option =>
            option.setName('spamyoneticirolu')
                .setDescription('Spam loglarını yönetecek yetkili rolü')
                .setRequired(true))
        .addRoleOption(option =>
            option.setName('loggorme')
                .setDescription('Logları görme yetkisi olan rol (isteğe bağlı)')
                .setRequired(false)),

    async execute(interaction) {
        try {
            await interaction.deferReply();

            const ownerRole = interaction.options.getRole('ownerrolu');
            const kufurYoneticiRole = interaction.options.getRole('kufuryoneticirolu');
            const spamYoneticiRole = interaction.options.getRole('spamyoneticirolu');
            const logGormeRole = interaction.options.getRole('loggorme');

            const configPath = path.join(__dirname, '../../config.json');
            const config = JSON.parse(fs.readFileSync(configPath, 'utf8'));

            const logChannels = [
                { name: '💻・ɢɪʀɪꜱ ʟᴏɢ', key: 'girisLog', description: 'Sunucuya giriş logları' },
                { name: '🚪・ᴄ̧ɪᴋɪꜱ ʟᴏɢ', key: 'cikisLog', description: 'Sunucudan çıkış logları' },
                { name: '🎭・ʀᴏʟ ʟᴏɢ', key: 'rolLog', description: 'Rol değişiklik logları' },
                { name: '🔨・ʙᴀɴ ʟᴏɢ', key: 'banLog', description: 'Ban işlem logları' },
                { name: '👢・ᴋɪᴄᴋ ʟᴏɢ', key: 'kickLog', description: 'Kick işlem logları' },
                { name: '🔓・ᴜɴʙᴀɴ ʟᴏɢ', key: 'unbanLog', description: 'Unban işlem logları' },
                { name: '🔍・ꜱ̧ᴜ̈ᴘʜᴇʟɪ ʟᴏɢ', key: 'suuheliLog', description: 'Şüpheli hesap logları' },
                { name: '🎫・ᴅᴀᴠᴇᴛ ʟᴏɢ', key: 'davetLog', description: 'Davet işlem logları' },
                { name: '🔇・ᴍᴜᴛᴇ ʟᴏɢ', key: 'muteLog', description: 'Mute işlem logları' },
                { name: '⏰・ᴛɪᴍᴇᴏᴜᴛ ʟᴏɢ', key: 'timeoutLog', description: 'Timeout işlem logları' },
                { name: '🎭・ᴏᴛᴏʀᴏʟ ʟᴏɢ', key: 'otorolLog', description: 'Otomatik rol verme logları' },
                { name: '🚫・ꜱᴘᴀᴍ ʟᴏɢ', key: 'spamLog', description: 'Spam tespit logları' },
                { name: '🤬・ᴋᴜ̈ꜰᴜ̈ʀ ʟᴏɢ', key: 'kufurLog', description: 'Küfür tespit logları' },
                { name: '💬・ᴍᴇꜱᴀᴊ ʟᴏɢ', key: 'mesajLog', description: 'Mesaj düzenleme/silme logları' },
                { name: '🎟️・ᴛɪᴄᴋᴇᴛ ᴀᴄ̧ᴍᴀ', key: 'ticketAcmaLog', description: 'Ticket açma logları' },
                { name: '🔒・ᴛɪᴄᴋᴇᴛ ᴋᴀᴘᴀᴍᴀ', key: 'ticketKapamaLog', description: 'Ticket kapatma logları' },
                { name: '📄・ᴛɪᴄᴋᴇᴛ ᴛʀᴀɴꜱᴄʀɪᴘᴛ', key: 'ticketTranscriptLog', description: 'Ticket transcript logları' },
                { name: '🎯・ᴛɪᴄᴋᴇᴛ ᴄʟᴀɪᴍ', key: 'claimLog', description: 'Ticket claim işlem logları' },
                { name: '🔔・ᴛɪᴄᴋᴇᴛ ᴅᴜ̈ʀᴛ', key: 'durtLog', description: 'Ticket dürt işlem logları' },
                { name: '👥・ᴛɪᴄᴋᴇᴛ ᴜ̈ʏᴇ', key: 'ticketUyeLog', description: 'Ticket üye ekleme/kaldırma logları' },
                { name: '🔓・ʙᴀɴ ᴀꜰꜰɪ ʟᴏɢ', key: 'banAffiLog', description: 'Ban affı işlem logları' },
                { name: '💾・ʏᴇᴅᴇᴋʟᴇᴍᴇ ʟᴏɢ', key: 'backupLog', description: 'Yedekleme sistemi işlem logları' },
                { name: '👥・ʜᴇʀᴋᴇꜱᴇ ʀᴏʟ ᴠᴇʀ ʟᴏɢ', key: 'herkeseRolVerLog', description: 'Herkese rol verme işlem logları' },
                { name: '👤・ʜᴇʀᴋᴇꜱᴛᴇɴ ʀᴏʟ ᴀʟ ʟᴏɢ', key: 'herkestenRolAlLog', description: 'Herkesten rol alma işlem logları' },
                { name: '🎉・ᴄ̧ᴇᴋɪʟɪꜱ ʟᴏɢ', key: 'cekilisLog', description: 'Çekiliş işlem logları' },
                { name: '🎭・ʀᴏʟ ɪꜱ̧ʟᴇᴍ ʟᴏɢ', key: 'rolIslemLog', description: 'Rol verme/alma işlem logları' },
                { name: '🗑️・ᴍᴇꜱᴀᴊ ꜱɪʟ ʟᴏɢ', key: 'mesajSilLog', description: 'Mesaj silme işlem logları' },
                { name: '🔊・ꜱᴇꜱ ɪꜱ̧ʟᴇᴍ ʟᴏɢ', key: 'sesIslemLog', description: 'Ses kanalı yönetim işlem logları' },
                { name: '💥・ɴᴜᴋᴇ ʟᴏɢ', key: 'nukeLog', description: 'Kanal nuke işlem logları' },
                { name: '🖥️・ꜱᴜɴᴜᴄᴜ ᴅᴜʀᴜᴍ ᴇᴍʙᴇᴅ ʟᴏɢ', key: 'sunucuDurumEmbedLog', description: 'Sunucu durum embed ayar logları' },
                { name: '📊・ꜱᴜɴᴜᴄᴜ ᴅᴜʀᴜᴍ ʟᴏɢ', key: 'sunucuDurumLog', description: 'Sunucu durum güncelleme logları' },
                { name: '🎫・ᴡʜɪᴛᴇʟɪꜱᴛ ʟᴏɢ', key: 'wlLog', description: 'Whitelist verme/alma işlem logları' },
                { name: '⚙️・ᴡʜɪᴛᴇʟɪꜱᴛ ᴀʏᴀʀ ʟᴏɢ', key: 'wlAyarlaLog', description: 'Whitelist ayar güncelleme logları' },
                { name: '📝・ɪᴄ ɪꜱɪᴍ ᴀʏᴀʀ ʟᴏɢ', key: 'icisimAyarlaLog', description: 'IC İsim sistem ayar logları' },
                { name: '✅・ɪᴄ ɪꜱɪᴍ ᴏɴᴀʏ ʀᴇᴅ ʟᴏɢ', key: 'icisimOnayRedLog', description: 'IC İsim onay/red işlem logları' },
                { name: '🎭・ʀᴏʟ ʙɪʟɢɪ ʟᴏɢ', key: 'rolBilgiLog', description: 'Rol bilgi komutu kullanım logları' }
            ];

            const category = await interaction.guild.channels.create({
                name: 'RoveBot\'s Service\'s Bot Logs',
                type: ChannelType.GuildCategory,
                permissionOverwrites: [
                    {
                        id: interaction.guild.roles.everyone.id,
                        deny: [PermissionFlagsBits.ViewChannel]
                    },
                    {
                        id: ownerRole.id,
                        allow: [
                            PermissionFlagsBits.ViewChannel,
                            PermissionFlagsBits.ManageChannels,
                            PermissionFlagsBits.ManageMessages,
                            PermissionFlagsBits.ReadMessageHistory
                        ]
                    }
                ]
            });

            if (logGormeRole) {
                await category.permissionOverwrites.create(logGormeRole, {
                    ViewChannel: true,
                    ReadMessageHistory: true
                });
            }

            const createdChannels = {};
            const setupEmbed = new EmbedBuilder()
                .setTitle('📋 Log Sistemi Kurulumu')
                .setColor('#00ff00')
                .setTimestamp();

            let channelList = '';

            for (const channelInfo of logChannels) {
                const permissionOverwrites = [
                    {
                        id: interaction.guild.roles.everyone.id,
                        deny: [PermissionFlagsBits.ViewChannel]
                    },
                    {
                        id: ownerRole.id,
                        allow: [
                            PermissionFlagsBits.ViewChannel,
                            PermissionFlagsBits.ManageChannels,
                            PermissionFlagsBits.ManageMessages,
                            PermissionFlagsBits.ReadMessageHistory
                        ]
                    }
                ];

                if (channelInfo.key === 'kufurLog') {
                    permissionOverwrites.push({
                        id: kufurYoneticiRole.id,
                        allow: [
                            PermissionFlagsBits.ViewChannel,
                            PermissionFlagsBits.ManageMessages,
                            PermissionFlagsBits.ReadMessageHistory
                        ]
                    });
                }

                if (channelInfo.key === 'spamLog') {
                    permissionOverwrites.push({
                        id: spamYoneticiRole.id,
                        allow: [
                            PermissionFlagsBits.ViewChannel,
                            PermissionFlagsBits.ManageMessages,
                            PermissionFlagsBits.ReadMessageHistory
                        ]
                    });
                }

                if (logGormeRole) {
                    permissionOverwrites.push({
                        id: logGormeRole.id,
                        allow: [
                            PermissionFlagsBits.ViewChannel,
                            PermissionFlagsBits.ReadMessageHistory
                        ]
                    });
                }

                const channel = await interaction.guild.channels.create({
                    name: channelInfo.name,
                    type: ChannelType.GuildText,
                    parent: category.id,
                    permissionOverwrites: permissionOverwrites
                });

                createdChannels[channelInfo.key] = channel.id;
                channelList += `${channelInfo.name} - <#${channel.id}>\n`;

                const channelEmbed = new EmbedBuilder()
                    .setTitle(`📋 ${channelInfo.description}`)
                    .setDescription(`Bu kanal **${channelInfo.description.toLowerCase()}** için kullanılmaktadır.\n\n**Yetkili Roller:**\n• <@&${ownerRole.id}> - Tam Yetki\n${channelInfo.key === 'kufurLog' ? `• <@&${kufurYoneticiRole.id}> - Küfür Yönetimi\n` : ''}${channelInfo.key === 'spamLog' ? `• <@&${spamYoneticiRole.id}> - Spam Yönetimi\n` : ''}${logGormeRole ? `• <@&${logGormeRole.id}> - Görüntüleme\n` : ''}`)
                    .setColor('#0099ff')
                    .setTimestamp();

                await channel.send({ embeds: [channelEmbed] });
            }

            config.LogSistemi.aktif = true;
            config.LogSistemi.logKanallari = createdChannels;
            config.LogSistemi.logRolleri = {
                ownerRolu: ownerRole.id,
                kufurYoneticiRolu: kufurYoneticiRole.id,
                spamYoneticiRolu: spamYoneticiRole.id,
                logGormeRolu: logGormeRole ? logGormeRole.id : ""
            };
            config.LogSistemi.logKategoriId = category.id;

            fs.writeFileSync(configPath, JSON.stringify(config, null, 4));

            if (interaction.client.logSistemi) {
                interaction.client.logSistemi.reloadConfig();
            }

            setupEmbed.setDescription(`✅ **Log sistemi başarıyla kuruldu!**\n\n**Oluşturulan Kategori:**\n📁 ${category.name} - <#${category.id}>\n\n**Oluşturulan Kanallar:**\n${channelList}\n**Yetkili Roller:**\n• **Owner Rolü:** <@&${ownerRole.id}>\n• **Küfür Yöneticisi:** <@&${kufurYoneticiRole.id}>\n• **Spam Yöneticisi:** <@&${spamYoneticiRole.id}>${logGormeRole ? `\n• **Log Görme:** <@&${logGormeRole.id}>` : ''}\n\n🔄 **Sistem otomatik olarak aktifleştirildi!**`);

            await interaction.editReply({ embeds: [setupEmbed] });

        } catch (error) {
            console.error('Setup log komutu hatası:', error);
            
            const errorEmbed = new EmbedBuilder()
                .setTitle('❌ Hata Oluştu')
                .setDescription(`Log sistemi kurulurken bir hata oluştu:\n\`\`\`${error.message}\`\`\``)
                .setColor('#ff0000')
                .setTimestamp();

            await interaction.editReply({ embeds: [errorEmbed] });
        }
    }
};