const { SlashCommandBuilder, EmbedBuilder, PermissionFlagsBits, ChannelType } = require('discord.js');
const { checkPermission } = require('./yetkiayarla');
const fs = require('fs');
const path = require('path');

module.exports = {
    data: new SlashCommandBuilder()
        .setName('logguncelle')
        .setDescription('Log sistemini günceller ve eksik kanalları otomatik oluşturur'),

    async execute(interaction) {
        try {
            if (!checkPermission(interaction, 'logguncelle')) {
                const errorEmbed = new EmbedBuilder()
                    .setColor(0xff0000)
                    .setTitle('❌ Yetkisiz Erişim')
                    .setDescription('Bu komutu kullanmak için Log Güncelleme yetkisine sahip olmalısınız!')
                    .setTimestamp();

                return await interaction.reply({ embeds: [errorEmbed], ephemeral: true });
            }

            await interaction.deferReply();

            const configPath = path.join(__dirname, '../../config.json');
            const config = JSON.parse(fs.readFileSync(configPath, 'utf8'));

            const requiredChannels = [
                { name: '💻・ɢɪʀɪꜱ ʟᴏɢ', key: 'girisLog', description: 'Sunucuya giriş logları' },
                { name: '🚪・ᴄ̧ɪᴋɪꜱ ʟᴏɢ', key: 'cikisLog', description: 'Sunucudan çıkış logları' },
                { name: '🎭・ʀᴏʟ ʟᴏɢ', key: 'rolLog', description: 'Rol değişiklik logları' },
                { name: '🔨・ʙᴀɴ ʟᴏɢ', key: 'banLog', description: 'Ban işlem logları' },
                { name: '👢・ᴋɪᴄᴋ ʟᴏɢ', key: 'kickLog', description: 'Kick işlem logları' },
                { name: '🔓・ᴜɴʙᴀɴ ʟᴏɢ', key: 'unbanLog', description: 'Unban işlem logları' },
                { name: '🔍・ꜱ̧ᴜ̈ᴘʜᴇʟɪ ʟᴏɢ', key: 'suuheliLog', description: 'Şüpheli hesap logları' },
                { name: '🎫・ᴅᴀᴠᴇᴛ ʟᴏɢ', key: 'davetLog', description: 'Davet işlem logları' },
                { name: '🔇・ᴍᴜᴛᴇ ʟᴏɢ', key: 'muteLog', description: 'Mute işlem logları' },
                { name: '⏰・ᴛɪᴍᴇᴏᴜᴛ ʟᴏɢ', key: 'timeoutLog', description: 'Timeout işlem logları' },
                { name: '🎭・ᴏᴛᴏʀᴏʟ ʟᴏɢ', key: 'otorolLog', description: 'Otomatik rol verme logları' },
                { name: '🚫・ꜱᴘᴀᴍ ʟᴏɢ', key: 'spamLog', description: 'Spam tespit logları' },
                { name: '🤬・ᴋᴜ̈ꜰᴜ̈ʀ ʟᴏɢ', key: 'kufurLog', description: 'Küfür tespit logları' },
                { name: '💬・ᴍᴇꜱᴀᴊ ʟᴏɢ', key: 'mesajLog', description: 'Mesaj düzenleme/silme logları' },
                { name: '🎟️・ᴛɪᴄᴋᴇᴛ ᴀᴄ̧ᴍᴀ', key: 'ticketAcmaLog', description: 'Ticket açma logları' },
                { name: '🔒・ᴛɪᴄᴋᴇᴛ ᴋᴀᴘᴀᴍᴀ', key: 'ticketKapamaLog', description: 'Ticket kapatma logları' },
                { name: '📄・ᴛɪᴄᴋᴇᴛ ᴛʀᴀɴꜱᴄʀɪᴘᴛ', key: 'ticketTranscriptLog', description: 'Ticket transcript logları' },
                { name: '🎯・ᴛɪᴄᴋᴇᴛ ᴄʟᴀɪᴍ', key: 'claimLog', description: 'Ticket claim işlem logları' },
                { name: '🔔・ᴛɪᴄᴋᴇᴛ ᴅᴜ̈ʀᴛ', key: 'durtLog', description: 'Ticket dürt işlem logları' },
                { name: '👥・ᴛɪᴄᴋᴇᴛ ᴜ̈ʏᴇ', key: 'ticketUyeLog', description: 'Ticket üye ekleme/kaldırma logları' },
                { name: '🔓・ʙᴀɴ ᴀꜰꜰɪ ʟᴏɢ', key: 'banAffiLog', description: 'Ban affı işlem logları' },
                { name: '💾・ʏᴇᴅᴇᴋʟᴇᴍᴇ ʟᴏɢ', key: 'backupLog', description: 'Yedekleme sistemi işlem logları' },
                { name: '👥・ʜᴇʀᴋᴇꜱᴇ ʀᴏʟ ᴠᴇʀ ʟᴏɢ', key: 'herkeseRolVerLog', description: 'Herkese rol verme işlem logları' },
                { name: '👤・ʜᴇʀᴋᴇꜱᴛᴇɴ ʀᴏʟ ᴀʟ ʟᴏɢ', key: 'herkestenRolAlLog', description: 'Herkesten rol alma işlem logları' },
                { name: '🎉・ᴄ̧ᴇᴋɪʟɪꜱ ʟᴏɢ', key: 'cekilisLog', description: 'Çekiliş işlem logları' },
                { name: '🎭・ʀᴏʟ ɪꜱ̧ʟᴇᴍ ʟᴏɢ', key: 'rolIslemLog', description: 'Rol verme/alma işlem logları' },
                { name: '🗑️・ᴍᴇꜱᴀᴊ ꜱɪʟ ʟᴏɢ', key: 'mesajSilLog', description: 'Mesaj silme işlem logları' },
                { name: '🔊・ꜱᴇꜱ ɪꜱ̧ʟᴇᴍ ʟᴏɢ', key: 'sesIslemLog', description: 'Ses kanalı yönetim işlem logları' },
                { name: '💥・ɴᴜᴋᴇ ʟᴏɢ', key: 'nukeLog', description: 'Kanal nuke işlem logları' },
                { name: '🖥️・ꜱᴜɴᴜᴄᴜ ᴅᴜʀᴜᴍ ᴇᴍʙᴇᴅ ʟᴏɢ', key: 'sunucuDurumEmbedLog', description: 'Sunucu durum embed ayar logları' },
                { name: '📊・ꜱᴜɴᴜᴄᴜ ᴅᴜʀᴜᴍ ʟᴏɢ', key: 'sunucuDurumLog', description: 'Sunucu durum güncelleme logları' },
                { name: '🎫・ᴡʜɪᴛᴇʟɪꜱᴛ ʟᴏɢ', key: 'wlLog', description: 'Whitelist verme/alma işlem logları' },
                { name: '⚙️・ᴡʜɪᴛᴇʟɪꜱᴛ ᴀʏᴀʀ ʟᴏɢ', key: 'wlAyarlaLog', description: 'Whitelist ayar güncelleme logları' },
                { name: '📝・ɪᴄ ɪꜱɪᴍ ᴀʏᴀʀ ʟᴏɢ', key: 'icisimAyarlaLog', description: 'IC İsim sistem ayar logları' },
                { name: '✅・ɪᴄ ɪꜱɪᴍ ᴏɴᴀʏ ʀᴇᴅ ʟᴏɢ', key: 'icisimOnayRedLog', description: 'IC İsim onay/red işlem logları' },
                { name: '🎭・ʀᴏʟ ʙɪʟɢɪ ʟᴏɢ', key: 'rolBilgiLog', description: 'Rol bilgi komutu kullanım logları' }
            ];

            const currentChannels = config.LogSistemi.logKanallari || {};
            const missingChannels = [];
            const existingChannels = [];
            const invalidChannels = [];

            for (const channelInfo of requiredChannels) {
                const channelId = currentChannels[channelInfo.key];
                
                if (!channelId) {
                    missingChannels.push(channelInfo);
                } else {
                    const channel = interaction.guild.channels.cache.get(channelId);
                    if (channel) {
                        existingChannels.push({ ...channelInfo, channel });
                    } else {
                        invalidChannels.push(channelInfo);
                        missingChannels.push(channelInfo);
                    }
                }
            }

            let updateEmbed = new EmbedBuilder()
                .setTitle('🔄 Log Sistemi Güncelleniyor...')
                .setColor('#ffaa00')
                .setTimestamp();

            if (missingChannels.length === 0 && invalidChannels.length === 0) {
                updateEmbed
                    .setTitle('✅ Log Sistemi Güncel')
                    .setDescription('Tüm log kanalları mevcut ve çalışıyor!')
                    .setColor('#00ff00');

                // Split existing channels into multiple fields to avoid 1024 character limit
                const channelList = existingChannels.map(ch => `${ch.name} - <#${ch.channel.id}>`);
                const maxFieldLength = 1000; // Leave some buffer under 1024 limit
                
                let currentField = '';
                let fieldIndex = 1;
                
                for (const channelEntry of channelList) {
                    if (currentField.length + channelEntry.length + 1 > maxFieldLength) {
                        // Add current field and start new one
                        updateEmbed.addFields({
                            name: fieldIndex === 1 ? '📊 Mevcut Kanallar' : `📊 Mevcut Kanallar (Devamı ${fieldIndex})`,
                            value: currentField,
                            inline: false
                        });
                        currentField = channelEntry;
                        fieldIndex++;
                    } else {
                        if (currentField) currentField += '\n';
                        currentField += channelEntry;
                    }
                }
                
                // Add the last field if there's content
                if (currentField) {
                    updateEmbed.addFields({
                        name: fieldIndex === 1 ? '📊 Mevcut Kanallar' : `📊 Mevcut Kanallar (Devamı ${fieldIndex})`,
                        value: currentField,
                        inline: false
                    });
                }

                return await interaction.editReply({ embeds: [updateEmbed] });
            }

            let category = null;
            if (config.LogSistemi.logKategoriId) {
                category = interaction.guild.channels.cache.get(config.LogSistemi.logKategoriId);
            }

            if (!category) {
                category = await interaction.guild.channels.create({
                    name: '📋 LOG SİSTEMİ',
                    type: ChannelType.GuildCategory,
                    permissionOverwrites: [
                        {
                            id: interaction.guild.roles.everyone.id,
                            deny: [PermissionFlagsBits.ViewChannel]
                        },
                        {
                            id: interaction.guild.members.me.id,
                            allow: [
                                PermissionFlagsBits.ViewChannel,
                                PermissionFlagsBits.SendMessages,
                                PermissionFlagsBits.ReadMessageHistory,
                                PermissionFlagsBits.ManageChannels
                            ]
                        }
                    ]
                });
                config.LogSistemi.logKategoriId = category.id;
            }

            const createdChannels = [];
            const updatedConfig = { ...currentChannels };

            for (const channelInfo of missingChannels) {
                try {
                    const permissionOverwrites = [
                        {
                            id: interaction.guild.roles.everyone.id,
                            deny: [PermissionFlagsBits.ViewChannel]
                        },
                        {
                            id: interaction.guild.members.me.id,
                            allow: [
                                PermissionFlagsBits.ViewChannel,
                                PermissionFlagsBits.SendMessages,
                                PermissionFlagsBits.ReadMessageHistory
                            ]
                        }
                    ];

                    // Log görme rolünü config.json'dan al ve izin ver
                    if (config.LogSistemi.logRolleri && config.LogSistemi.logRolleri.logGormeRolu) {
                        const logGormeRoleId = config.LogSistemi.logRolleri.logGormeRolu;
                        const logGormeRole = interaction.guild.roles.cache.get(logGormeRoleId);
                        if (logGormeRole) {
                            permissionOverwrites.push({
                                id: logGormeRole.id,
                                allow: [
                                    PermissionFlagsBits.ViewChannel,
                                    PermissionFlagsBits.ReadMessageHistory
                                ]
                            });
                        }
                    }

                    const channel = await interaction.guild.channels.create({
                        name: channelInfo.name,
                        type: ChannelType.GuildText,
                        parent: category.id,
                        permissionOverwrites: permissionOverwrites
                    });

                    updatedConfig[channelInfo.key] = channel.id;
                    createdChannels.push({ ...channelInfo, channel });

                    const channelEmbed = new EmbedBuilder()
                        .setTitle(`📋 ${channelInfo.description}`)
                        .setDescription(`Bu kanal **${channelInfo.description.toLowerCase()}** için kullanılmaktadır.\n\n⚠️ **Otomatik olarak oluşturuldu**\n\n**Yetkili Rolleri:**\nYetkili rolleri ayarlamak için \`/setuplog\` komutunu kullanın.`)
                        .setColor('#0099ff')
                        .setTimestamp();

                    await channel.send({ embeds: [channelEmbed] });

                } catch (error) {
                    console.error(`${channelInfo.name} kanalı oluşturulurken hata:`, error);
                }
            }

            config.LogSistemi.logKanallari = updatedConfig;
            config.LogSistemi.aktif = true;
            fs.writeFileSync(configPath, JSON.stringify(config, null, 4));

            if (interaction.client.logSistemi) {
                interaction.client.logSistemi.reloadConfig();
            }

            updateEmbed
                .setTitle('✅ Log Sistemi Güncellendi')
                .setDescription(`Log sistemi başarıyla güncellendi!\n\n**Kategori:** <#${category.id}>`)
                .setColor('#00ff00');

            if (existingChannels.length > 0) {
                // Split existing channels into multiple fields to avoid 1024 character limit
                const channelList = existingChannels.map(ch => `${ch.name} - <#${ch.channel.id}>`);
                const maxFieldLength = 1000; // Leave some buffer under 1024 limit
                
                let currentField = '';
                let fieldIndex = 1;
                
                for (const channelEntry of channelList) {
                    if (currentField.length + channelEntry.length + 1 > maxFieldLength) {
                        // Add current field and start new one
                        updateEmbed.addFields({
                            name: fieldIndex === 1 ? '✅ Mevcut Kanallar' : `✅ Mevcut Kanallar (Devamı ${fieldIndex})`,
                            value: currentField,
                            inline: false
                        });
                        currentField = channelEntry;
                        fieldIndex++;
                    } else {
                        if (currentField) currentField += '\n';
                        currentField += channelEntry;
                    }
                }
                
                // Add the last field if there's content
                if (currentField) {
                    updateEmbed.addFields({
                        name: fieldIndex === 1 ? '✅ Mevcut Kanallar' : `✅ Mevcut Kanallar (Devamı ${fieldIndex})`,
                        value: currentField,
                        inline: false
                    });
                }
            }

            if (createdChannels.length > 0) {
                // Split created channels into multiple fields to avoid 1024 character limit
                const channelList = createdChannels.map(ch => `${ch.name} - <#${ch.channel.id}>`);
                const maxFieldLength = 1000; // Leave some buffer under 1024 limit
                
                let currentField = '';
                let fieldIndex = 1;
                
                for (const channelEntry of channelList) {
                    if (currentField.length + channelEntry.length + 1 > maxFieldLength) {
                        // Add current field and start new one
                        updateEmbed.addFields({
                            name: fieldIndex === 1 ? '🆕 Oluşturulan Kanallar' : `🆕 Oluşturulan Kanallar (Devamı ${fieldIndex})`,
                            value: currentField,
                            inline: false
                        });
                        currentField = channelEntry;
                        fieldIndex++;
                    } else {
                        if (currentField) currentField += '\n';
                        currentField += channelEntry;
                    }
                }
                
                // Add the last field if there's content
                if (currentField) {
                    updateEmbed.addFields({
                        name: fieldIndex === 1 ? '🆕 Oluşturulan Kanallar' : `🆕 Oluşturulan Kanallar (Devamı ${fieldIndex})`,
                        value: currentField,
                        inline: false
                    });
                }
            }

            if (invalidChannels.length > 0) {
                // Split invalid channels into multiple fields to avoid 1024 character limit
                const channelList = invalidChannels.map(ch => `${ch.name} - Eski kanal silinmiş, yeniden oluşturuldu`);
                const maxFieldLength = 1000; // Leave some buffer under 1024 limit
                
                let currentField = '';
                let fieldIndex = 1;
                
                for (const channelEntry of channelList) {
                    if (currentField.length + channelEntry.length + 1 > maxFieldLength) {
                        // Add current field and start new one
                        updateEmbed.addFields({
                            name: fieldIndex === 1 ? '🔄 Yeniden Oluşturulan Kanallar' : `🔄 Yeniden Oluşturulan Kanallar (Devamı ${fieldIndex})`,
                            value: currentField,
                            inline: false
                        });
                        currentField = channelEntry;
                        fieldIndex++;
                    } else {
                        if (currentField) currentField += '\n';
                        currentField += channelEntry;
                    }
                }
                
                // Add the last field if there's content
                if (currentField) {
                    updateEmbed.addFields({
                        name: fieldIndex === 1 ? '🔄 Yeniden Oluşturulan Kanallar' : `🔄 Yeniden Oluşturulan Kanallar (Devamı ${fieldIndex})`,
                        value: currentField,
                        inline: false
                    });
                }
            }

            updateEmbed.addFields({
                name: '📊 Özet',
                value: `• **Toplam Kanal:** ${requiredChannels.length}\n• **Mevcut:** ${existingChannels.length}\n• **Oluşturulan:** ${createdChannels.length}\n• **Güncellenen:** ${invalidChannels.length}`,
                inline: false
            });

            await interaction.editReply({ embeds: [updateEmbed] });

        } catch (error) {
            console.error('Logguncelle komutu hatası:', error);
            
            const errorEmbed = new EmbedBuilder()
                .setTitle('❌ Hata Oluştu')
                .setDescription(`Log sistemi güncellenirken bir hata oluştu:\n\`\`\`${error.message}\`\`\``)
                .setColor('#ff0000')
                .setTimestamp();

            await interaction.editReply({ embeds: [errorEmbed] });
        }
    }
};
