const { SlashCommandBuilder, EmbedBuilder, PermissionFlagsBits } = require('discord.js');
const { checkPermission } = require('./yetkiayarla');
const config = require('../../config.json');

module.exports = {
    data: new SlashCommandBuilder()
        .setName('kufurengel')
        .setDescription('Küfür engel sistemini yönetir.')
        .addStringOption(option =>
            option.setName('islem')
                .setDescription('Yapılacak işlem')
                .setRequired(true)
                .addChoices(
                    { name: '🟢 Sistemi Aç', value: 'ac' },
                    { name: '🔴 Sistemi Kapat', value: 'kapat' },
                    { name: '📊 Sistem Durumu', value: 'durum' },
                    { name: '📈 İstatistikler', value: 'istatistik' },
                    { name: '👤 İstisna Kullanıcı(lar)', value: 'istisna_kullanici' },
                    { name: '📺 İstisna Oda(lar)', value: 'istisna_oda' },
                    { name: '🎭 İstisna Rol(ler)', value: 'istisna_rol' }
                ))
        .addUserOption(option =>
            option.setName('kullanici')
                .setDescription('Kullanıcı istatistikleri için (opsiyonel)')
                .setRequired(false))
        .addChannelOption(option =>
            option.setName('kanal')
                .setDescription('İstisna işlemleri için kanal (opsiyonel)')
                .setRequired(false))
        .addRoleOption(option =>
            option.setName('rol')
                .setDescription('İstisna işlemleri için rol (opsiyonel)')
                .setRequired(false))
        .addStringOption(option =>
            option.setName('eylem')
                .setDescription('İstisna işlemi (ekle/kaldır/listele)')
                .setRequired(false)
                .addChoices(
                    { name: '➕ Ekle', value: 'ekle' },
                    { name: '➖ Kaldır', value: 'kaldir' },
                    { name: '📋 Listele', value: 'listele' }
                )),
    
    async execute(interaction) {
        if (!checkPermission(interaction, 'kufurengel')) {
            const errorEmbed = new EmbedBuilder()
                .setColor(0xff0000)
                .setTitle('❌ Yetkisiz Erişim')
                .setDescription('Bu komutu kullanmak için Küfür Engel yetkisine sahip olmalısınız!')
                .setTimestamp();

            return await interaction.reply({ embeds: [errorEmbed], ephemeral: true });
        }

        const hasPermission = interaction.member.permissions.has(PermissionFlagsBits.ManageMessages) ||
                            config.KufurSistemi.yoneticiRolleri.some(roleId => 
                                interaction.member.roles.cache.has(roleId));
        
        if (!hasPermission) {
            const errorEmbed = new EmbedBuilder()
                .setColor(0xff0000)
                .setTitle('❌ Yetki Hatası')
                .setDescription('Bu komutu kullanmak için yeterli yetkiniz yok.')
                .addFields({
                    name: '📋 Gerekli Yetkiler',
                    value: '• Mesajları Yönet yetkisi\n• Yönetici rolü'
                })
                .setTimestamp();
            
            return await interaction.reply({ embeds: [errorEmbed], ephemeral: true });
        }
        
        const islem = interaction.options.getString('islem');
        const kullanici = interaction.options.getUser('kullanici');
        const kanal = interaction.options.getChannel('kanal');
        const rol = interaction.options.getRole('rol');
        const eylem = interaction.options.getString('eylem');
        const kufurSistemi = interaction.client.kufurSistemi;
        
        if (!kufurSistemi) {
            const errorEmbed = new EmbedBuilder()
                .setColor(0xff0000)
                .setTitle('❌ Sistem Hatası')
                .setDescription('Küfür sistemi başlatılamadı.')
                .setTimestamp();
            
            return await interaction.reply({ embeds: [errorEmbed], ephemeral: true });
        }
        
        switch (islem) {
            case 'ac':
                kufurSistemi.toggleSystem(true);
                const acEmbed = new EmbedBuilder()
                    .setColor(0x00ff00)
                    .setTitle('🟢 Sistem Aktifleştirildi')
                    .setDescription('Küfür engel sistemi başarıyla aktifleştirildi.')
                    .addFields(
                        {
                            name: '⚙️ Aktif Özellikler',
                            value: '• Otomatik küfür tespiti\n• Kademeli timeout sistemi\n• Dini/Milli küfür koruması\n• Otomatik loglama'
                        },
                        {
                            name: '📊 Timeout Süreleri',
                            value: `• 1-2. Küfür: Uyarı\n• 3. Küfür: 1 dakika\n• 4. Küfür: 5 dakika\n• 5+ Küfür: 10 dakika\n• Dini/Milli: 5 dakika (anında)`
                        }
                    )
                    .setFooter({ text: `RoveBot\'s • Küfür Engel Sistemi` })
                    .setTimestamp();
                
                await interaction.reply({ embeds: [acEmbed] });
                break;
                
            case 'kapat':
                kufurSistemi.toggleSystem(false);
                const kapatEmbed = new EmbedBuilder()
                    .setColor(0xff0000)
                    .setTitle('🔴 Sistem Devre Dışı')
                    .setDescription('Küfür engel sistemi devre dışı bırakıldı.')
                    .addFields({
                        name: '⚠️ Uyarı',
                        value: 'Sistem kapalıyken küfür kontrolü yapılmayacak ve timeout uygulanmayacaktır.'
                    })
                    .setFooter({ text: `RoveBot\'s • Küfür Engel Sistemi` })
                    .setTimestamp();
                
                await interaction.reply({ embeds: [kapatEmbed] });
                break;
                
            case 'durum':
                const sistemAktif = kufurSistemi.isActive();
                const durumEmbed = new EmbedBuilder()
                    .setColor(sistemAktif ? 0x00ff00 : 0xff0000)
                    .setTitle('📊 Küfür Sistemi Durumu')
                    .setDescription(`Sistem şu anda **${sistemAktif ? 'AKTİF' : 'KAPALI'}**`)
                    .addFields(
                        {
                            name: '⚙️ Sistem Bilgileri',
                            value: `• Durum: ${sistemAktif ? '🟢 Aktif' : '🔴 Kapalı'}\n• Normal Küfürler: ${kufurSistemi.normalKufurler.length}\n• Dini Küfürler: ${kufurSistemi.diniKufurler.length}\n• Milli Küfürler: ${kufurSistemi.milliKufurler.length}`,
                            inline: true
                        },
                        {
                            name: '📋 Ayarlar',
                            value: `• Log Kanalı: ${config.KufurSistemi.kufurlogchannelid !== 'KANAL_ID_BURAYA' ? '✅ Ayarlandı' : '❌ Ayarlanmadı'}\n• Yönetici Rolleri: ${config.KufurSistemi.yoneticiRolleri.length}\n• Timeout Sistemi: ✅ Aktif`,
                            inline: true
                        }
                    )
                    .setFooter({ text: `RoveBot\'s • Küfür Engel Sistemi` })
                    .setTimestamp();
                
                await interaction.reply({ embeds: [durumEmbed] });
                break;
                
            case 'istatistik':
                if (kullanici) {
                    const userStats = kufurSistemi.getUserStats(kullanici.id);
                    const userEmbed = new EmbedBuilder()
                        .setColor(0x7289da)
                        .setTitle('👤 Kullanıcı İstatistikleri')
                        .setDescription(`**${kullanici.tag}** için küfür istatistikleri`)
                        .addFields(
                            {
                                name: '📊 Genel Bilgiler',
                                value: `• Toplam Küfür: **${userStats.kufurSayisi}**\n• Durum: ${userStats.timeoutBitisTarihi && userStats.timeoutBitisTarihi > new Date() ? '🔴 Timeout\'ta' : '🟢 Normal'}`,
                                inline: true
                            }
                        )
                        .setThumbnail(kullanici.displayAvatarURL())
                        .setFooter({ text: `RoveBot\'s • Küfür Engel Sistemi` })
                        .setTimestamp();
                    
                    if (userStats.sonKufur) {
                        userEmbed.addFields({
                            name: '🕒 Son Küfür',
                            value: `• Kelime: \`${userStats.sonKufur.kelime}\`\n• Kategori: ${userStats.sonKufur.kategori}\n• Tarih: <t:${Math.floor(userStats.sonKufur.tarih.getTime() / 1000)}:R>`,
                            inline: true
                        });
                    }
                    
                    if (userStats.timeoutBitisTarihi && userStats.timeoutBitisTarihi > new Date()) {
                        userEmbed.addFields({
                            name: '⏱️ Timeout Bilgisi',
                            value: `• Bitiş: <t:${Math.floor(userStats.timeoutBitisTarihi.getTime() / 1000)}:R>\n• Kalan: <t:${Math.floor(userStats.timeoutBitisTarihi.getTime() / 1000)}:R>`,
                            inline: false
                        });
                    }
                    
                    await interaction.reply({ embeds: [userEmbed] });
                } else {
                    const systemStats = kufurSistemi.getSystemStats();
                    const statsEmbed = new EmbedBuilder()
                        .setColor(0x7289da)
                        .setTitle('📈 Sistem İstatistikleri')
                        .setDescription('Küfür engel sistemi genel istatistikleri')
                        .addFields(
                            {
                                name: '👥 Kullanıcı Verileri',
                                value: `• Kayıtlı Kullanıcı: **${systemStats.toplamKullanici}**\n• Toplam Küfür: **${systemStats.toplamKufur}**\n• Aktif Timeout: **${systemStats.aktifTimeoutlar}**`,
                                inline: true
                            },
                            {
                                name: '🛡️ Sistem Durumu',
                                value: `• Durum: ${systemStats.sistemAktif ? '🟢 Aktif' : '🔴 Kapalı'}\n• Kelime Sayısı: **${kufurSistemi.normalKufurler.length + kufurSistemi.diniKufurler.length + kufurSistemi.milliKufurler.length}**\n• Uptime: <t:${Math.floor((Date.now() - process.uptime() * 1000) / 1000)}:R>`,
                                inline: true
                            }
                        )
                        .setFooter({ text: `RoveBot\'s • Küfür Engel Sistemi` })
                        .setTimestamp();
                    
                    await interaction.reply({ embeds: [statsEmbed] });
                }
                break;
                
            case 'istisna_rol':
                if (!eylem) {
                    const errorEmbed = new EmbedBuilder()
                        .setColor(0xff0000)
                        .setTitle('❌ Eksik Parametre')
                        .setDescription('İstisna rol işlemi için eylem parametresi gereklidir.')
                        .addFields({
                            name: '📋 Kullanım',
                            value: '`/kufurengel islem:İstisna Rol(ler) eylem:ekle rol:@rol`\n`/kufurengel islem:İstisna Rol(ler) eylem:kaldır rol:@rol`\n`/kufurengel islem:İstisna Rol(ler) eylem:listele`'
                        })
                        .setTimestamp();
                    
                    return await interaction.reply({ embeds: [errorEmbed], ephemeral: true });
                }
                
                switch (eylem) {
                    case 'ekle':
                        if (!rol) {
                            const errorEmbed = new EmbedBuilder()
                                .setColor(0xff0000)
                                .setTitle('❌ Eksik Parametre')
                                .setDescription('Rol eklemek için rol parametresi gereklidir.')
                                .setTimestamp();
                            
                            return await interaction.reply({ embeds: [errorEmbed], ephemeral: true });
                        }
                        
                        const roleAdded = kufurSistemi.addExceptionRole(rol.id);
                        const roleAddEmbed = new EmbedBuilder()
                            .setColor(roleAdded ? 0x00ff00 : 0xffaa00)
                            .setTitle(roleAdded ? '✅ Rol Eklendi' : '⚠️ Rol Zaten Mevcut')
                            .setDescription(roleAdded ? 
                                `**${rol.name}** istisna roller listesine eklendi.` : 
                                `**${rol.name}** zaten istisna roller listesinde.`)
                            .addFields({
                                name: '🎭 Rol Bilgileri',
                                value: `• ID: \`${rol.id}\`\n• İsim: ${rol.name}\n• Renk: ${rol.hexColor}\n• Üye Sayısı: ${rol.members.size}\n• Durum: ${roleAdded ? 'Yeni eklendi' : 'Zaten mevcut'}`
                            })
                            .setFooter({ text: `RoveBot\'s • Küfür Engel Sistemi` })
                            .setTimestamp();
                        
                        await interaction.reply({ embeds: [roleAddEmbed] });
                        break;
                        
                    case 'kaldir':
                        if (!rol) {
                            const errorEmbed = new EmbedBuilder()
                                .setColor(0xff0000)
                                .setTitle('❌ Eksik Parametre')
                                .setDescription('Rol kaldırmak için rol parametresi gereklidir.')
                                .setTimestamp();
                            
                            return await interaction.reply({ embeds: [errorEmbed], ephemeral: true });
                        }
                        
                        const roleRemoved = kufurSistemi.removeExceptionRole(rol.id);
                        const roleRemoveEmbed = new EmbedBuilder()
                            .setColor(roleRemoved ? 0x00ff00 : 0xffaa00)
                            .setTitle(roleRemoved ? '✅ Rol Kaldırıldı' : '⚠️ Rol Bulunamadı')
                            .setDescription(roleRemoved ? 
                                `**${rol.name}** istisna roller listesinden kaldırıldı.` : 
                                `**${rol.name}** istisna roller listesinde bulunamadı.`)
                            .addFields({
                                name: '🎭 Rol Bilgileri',
                                value: `• ID: \`${rol.id}\`\n• İsim: ${rol.name}\n• Renk: ${rol.hexColor}\n• Üye Sayısı: ${rol.members.size}\n• Durum: ${roleRemoved ? 'Kaldırıldı' : 'Bulunamadı'}`
                            })
                            .setFooter({ text: `RoveBot\'s • Küfür Engel Sistemi` })
                            .setTimestamp();
                        
                        await interaction.reply({ embeds: [roleRemoveEmbed] });
                        break;
                        
                    case 'listele':
                        const exceptionRoles = kufurSistemi.getExceptionRoles();
                        const roleListEmbed = new EmbedBuilder()
                            .setColor(0x7289da)
                            .setTitle('🎭 İstisna Roller Listesi')
                            .setDescription(exceptionRoles.length > 0 ? 
                                `Toplam **${exceptionRoles.length}** istisna rol bulunuyor.` : 
                                'Henüz hiç istisna rol eklenmemiş.')
                            .setFooter({ text: `RoveBot\'s • Küfür Engel Sistemi` })
                            .setTimestamp();
                        
                        if (exceptionRoles.length > 0) {
                            const roleList = exceptionRoles.slice(0, 20).map((roleId, index) => {
                                const role = interaction.guild.roles.cache.get(roleId);
                                return `${index + 1}. ${role ? `**@${role.name}**` : `ID: \`${roleId}\``} (\`${roleId}\`)`;
                            }).join('\n');
                            
                            roleListEmbed.addFields({
                                name: '📋 Roller',
                                value: roleList + (exceptionRoles.length > 20 ? `\n\n*... ve ${exceptionRoles.length - 20} rol daha*` : '')
                            });
                        }
                        
                        await interaction.reply({ embeds: [roleListEmbed] });
                        break;
                }
                break;
                
            case 'istisna_oda':
                if (!eylem) {
                    const errorEmbed = new EmbedBuilder()
                        .setColor(0xff0000)
                        .setTitle('❌ Eksik Parametre')
                        .setDescription('İstisna oda işlemi için eylem parametresi gereklidir.')
                        .addFields({
                            name: '📋 Kullanım',
                            value: '`/kufurengel islem:İstisna Oda(lar) eylem:ekle kanal:#kanal`\n`/kufurengel islem:İstisna Oda(lar) eylem:kaldır kanal:#kanal`\n`/kufurengel islem:İstisna Oda(lar) eylem:listele`'
                        })
                        .setTimestamp();
                    
                    return await interaction.reply({ embeds: [errorEmbed], ephemeral: true });
                }
                
                switch (eylem) {
                    case 'ekle':
                        if (!kanal) {
                            const errorEmbed = new EmbedBuilder()
                                .setColor(0xff0000)
                                .setTitle('❌ Eksik Parametre')
                                .setDescription('Kanal eklemek için kanal parametresi gereklidir.')
                                .setTimestamp();
                            
                            return await interaction.reply({ embeds: [errorEmbed], ephemeral: true });
                        }
                        
                        const channelAdded = kufurSistemi.addExceptionChannel(kanal.id);
                        const channelAddEmbed = new EmbedBuilder()
                            .setColor(channelAdded ? 0x00ff00 : 0xffaa00)
                            .setTitle(channelAdded ? '✅ Kanal Eklendi' : '⚠️ Kanal Zaten Mevcut')
                            .setDescription(channelAdded ? 
                                `**${kanal.name}** istisna kanallar listesine eklendi.` : 
                                `**${kanal.name}** zaten istisna kanallar listesinde.`)
                            .addFields({
                                name: '📺 Kanal Bilgileri',
                                value: `• ID: \`${kanal.id}\`\n• İsim: ${kanal.name}\n• Tip: ${kanal.type === 0 ? 'Metin Kanalı' : 'Diğer'}\n• Durum: ${channelAdded ? 'Yeni eklendi' : 'Zaten mevcut'}`
                            })
                            .setFooter({ text: `RoveBot\'s • Küfür Engel Sistemi` })
                            .setTimestamp();
                        
                        await interaction.reply({ embeds: [channelAddEmbed] });
                        break;
                        
                    case 'kaldir':
                        if (!kanal) {
                            const errorEmbed = new EmbedBuilder()
                                .setColor(0xff0000)
                                .setTitle('❌ Eksik Parametre')
                                .setDescription('Kanal kaldırmak için kanal parametresi gereklidir.')
                                .setTimestamp();
                            
                            return await interaction.reply({ embeds: [errorEmbed], ephemeral: true });
                        }
                        
                        const channelRemoved = kufurSistemi.removeExceptionChannel(kanal.id);
                        const channelRemoveEmbed = new EmbedBuilder()
                            .setColor(channelRemoved ? 0x00ff00 : 0xffaa00)
                            .setTitle(channelRemoved ? '✅ Kanal Kaldırıldı' : '⚠️ Kanal Bulunamadı')
                            .setDescription(channelRemoved ? 
                                `**${kanal.name}** istisna kanallar listesinden kaldırıldı.` : 
                                `**${kanal.name}** istisna kanallar listesinde bulunamadı.`)
                            .addFields({
                                name: '📺 Kanal Bilgileri',
                                value: `• ID: \`${kanal.id}\`\n• İsim: ${kanal.name}\n• Tip: ${kanal.type === 0 ? 'Metin Kanalı' : 'Diğer'}\n• Durum: ${channelRemoved ? 'Kaldırıldı' : 'Bulunamadı'}`
                            })
                            .setFooter({ text: `RoveBot\'s • Küfür Engel Sistemi` })
                            .setTimestamp();
                        
                        await interaction.reply({ embeds: [channelRemoveEmbed] });
                        break;
                        
                    case 'listele':
                        const exceptionChannels = kufurSistemi.getExceptionChannels();
                        const channelListEmbed = new EmbedBuilder()
                            .setColor(0x7289da)
                            .setTitle('📺 İstisna Kanallar Listesi')
                            .setDescription(exceptionChannels.length > 0 ? 
                                `Toplam **${exceptionChannels.length}** istisna kanal bulunuyor.` : 
                                'Henüz hiç istisna kanal eklenmemiş.')
                            .setFooter({ text: `RoveBot\'s • Küfür Engel Sistemi` })
                            .setTimestamp();
                        
                        if (exceptionChannels.length > 0) {
                            const channelList = exceptionChannels.slice(0, 20).map((channelId, index) => {
                                const channel = interaction.client.channels.cache.get(channelId);
                                return `${index + 1}. ${channel ? `**#${channel.name}**` : `ID: \`${channelId}\``} (\`${channelId}\`)`;
                            }).join('\n');
                            
                            channelListEmbed.addFields({
                                name: '📋 Kanallar',
                                value: channelList + (exceptionChannels.length > 20 ? `\n\n*... ve ${exceptionChannels.length - 20} kanal daha*` : '')
                            });
                        }
                        
                        await interaction.reply({ embeds: [channelListEmbed] });
                        break;
                }
                break;
                
            case 'istisna_kullanici':
                if (!eylem) {
                    const errorEmbed = new EmbedBuilder()
                        .setColor(0xff0000)
                        .setTitle('❌ Eksik Parametre')
                        .setDescription('İstisna kullanıcı işlemi için eylem parametresi gereklidir.')
                        .addFields({
                            name: '📋 Kullanım',
                            value: '`/kufurengel islem:İstisna Kullanıcı(lar) eylem:ekle kullanici:@kullanici`\n`/kufurengel islem:İstisna Kullanıcı(lar) eylem:kaldır kullanici:@kullanici`\n`/kufurengel islem:İstisna Kullanıcı(lar) eylem:listele`'
                        })
                        .setTimestamp();
                    
                    return await interaction.reply({ embeds: [errorEmbed], ephemeral: true });
                }
                
                switch (eylem) {
                    case 'ekle':
                        if (!kullanici) {
                            const errorEmbed = new EmbedBuilder()
                                .setColor(0xff0000)
                                .setTitle('❌ Eksik Parametre')
                                .setDescription('Kullanıcı eklemek için kullanıcı parametresi gereklidir.')
                                .setTimestamp();
                            
                            return await interaction.reply({ embeds: [errorEmbed], ephemeral: true });
                        }
                        
                        const userAdded = kufurSistemi.addExceptionUser(kullanici.id);
                        const userAddEmbed = new EmbedBuilder()
                            .setColor(userAdded ? 0x00ff00 : 0xffaa00)
                            .setTitle(userAdded ? '✅ Kullanıcı Eklendi' : '⚠️ Kullanıcı Zaten Mevcut')
                            .setDescription(userAdded ? 
                                `**${kullanici.tag}** istisna kullanıcılar listesine eklendi.` : 
                                `**${kullanici.tag}** zaten istisna kullanıcılar listesinde.`)
                            .addFields({
                                name: '👤 Kullanıcı Bilgileri',
                                value: `• ID: \`${kullanici.id}\`\n• Tag: ${kullanici.tag}\n• Durum: ${userAdded ? 'Yeni eklendi' : 'Zaten mevcut'}`
                            })
                            .setThumbnail(kullanici.displayAvatarURL())
                            .setFooter({ text: `RoveBot\'s • Küfür Engel Sistemi` })
                            .setTimestamp();
                        
                        await interaction.reply({ embeds: [userAddEmbed] });
                        break;
                        
                    case 'kaldir':
                        if (!kullanici) {
                            const errorEmbed = new EmbedBuilder()
                                .setColor(0xff0000)
                                .setTitle('❌ Eksik Parametre')
                                .setDescription('Kullanıcı kaldırmak için kullanıcı parametresi gereklidir.')
                                .setTimestamp();
                            
                            return await interaction.reply({ embeds: [errorEmbed], ephemeral: true });
                        }
                        
                        const userRemoved = kufurSistemi.removeExceptionUser(kullanici.id);
                        const userRemoveEmbed = new EmbedBuilder()
                            .setColor(userRemoved ? 0x00ff00 : 0xffaa00)
                            .setTitle(userRemoved ? '✅ Kullanıcı Kaldırıldı' : '⚠️ Kullanıcı Bulunamadı')
                            .setDescription(userRemoved ? 
                                `**${kullanici.tag}** istisna kullanıcılar listesinden kaldırıldı.` : 
                                `**${kullanici.tag}** istisna kullanıcılar listesinde bulunamadı.`)
                            .addFields({
                                name: '👤 Kullanıcı Bilgileri',
                                value: `• ID: \`${kullanici.id}\`\n• Tag: ${kullanici.tag}\n• Durum: ${userRemoved ? 'Kaldırıldı' : 'Bulunamadı'}`
                            })
                            .setThumbnail(kullanici.displayAvatarURL())
                            .setFooter({ text: `RoveBot\'s • Küfür Engel Sistemi` })
                            .setTimestamp();
                        
                        await interaction.reply({ embeds: [userRemoveEmbed] });
                        break;
                        
                    case 'listele':
                        const exceptionUsers = kufurSistemi.getExceptionUsers();
                        const userListEmbed = new EmbedBuilder()
                            .setColor(0x7289da)
                            .setTitle('👥 İstisna Kullanıcılar Listesi')
                            .setDescription(exceptionUsers.length > 0 ? 
                                `Toplam **${exceptionUsers.length}** istisna kullanıcı bulunuyor.` : 
                                'Henüz hiç istisna kullanıcı eklenmemiş.')
                            .setFooter({ text: `RoveBot\'s • Küfür Engel Sistemi` })
                            .setTimestamp();
                        
                        if (exceptionUsers.length > 0) {
                            const userList = exceptionUsers.slice(0, 20).map((userId, index) => {
                                const user = interaction.client.users.cache.get(userId);
                                return `${index + 1}. ${user ? `**${user.tag}**` : `ID: \`${userId}\``} (\`${userId}\`)`;
                            }).join('\n');
                            
                            userListEmbed.addFields({
                                name: '📋 Kullanıcılar',
                                value: userList + (exceptionUsers.length > 20 ? `\n\n*... ve ${exceptionUsers.length - 20} kullanıcı daha*` : '')
                            });
                        }
                        
                        await interaction.reply({ embeds: [userListEmbed] });
                        break;
                }
                break;
                
            default:
                const defaultEmbed = new EmbedBuilder()
                    .setColor(0xff0000)
                    .setTitle('❌ Geçersiz İşlem')
                    .setDescription('Lütfen geçerli bir işlem seçin.')
                    .setTimestamp();
                
                await interaction.reply({ embeds: [defaultEmbed], ephemeral: true });
        }
    },
};