const { SlashCommandBuilder, EmbedBuilder, PermissionFlagsBits } = require('discord.js');
const { checkPermission } = require('./yetkiayarla');
const fs = require('fs');
const path = require('path');
const LogSistemi = require('../logSistemi');

module.exports = {
    data: new SlashCommandBuilder()
        .setName('kick')
        .setDescription('Belirtilen kullanıcıyı sunucudan atar')
        .addUserOption(option =>
            option.setName('kullanici')
                .setDescription('Atılacak kullanıcı')
                .setRequired(true))
        .addStringOption(option =>
            option.setName('sebep')
                .setDescription('Atma sebebi')
                .setRequired(false)),

    async execute(interaction) {
        try {
            if (!checkPermission(interaction, 'kick')) {
                const errorEmbed = new EmbedBuilder()
                    .setColor(0xff0000)
                    .setTitle('❌ Yetkisiz Erişim')
                    .setDescription('Bu komutu kullanmak için Kick yetkisine sahip olmalısınız!')
                    .setTimestamp();

                return await interaction.reply({ embeds: [errorEmbed], ephemeral: true });
            }

            const targetUser = interaction.options.getUser('kullanici');
            const reason = interaction.options.getString('sebep') || 'Sebep belirtilmedi';

            if (targetUser.id === interaction.user.id) {
                const errorEmbed = new EmbedBuilder()
                    .setColor(0xff6600)
                    .setTitle('❌ Hata')
                    .setDescription('Kendinizi atamazsınız!')
                    .setTimestamp();

                return await interaction.reply({ embeds: [errorEmbed], ephemeral: true });
            }

            if (targetUser.id === interaction.client.user.id) {
                const errorEmbed = new EmbedBuilder()
                    .setColor(0xff6600)
                    .setTitle('❌ Hata')
                    .setDescription('Beni atamazsınız!')
                    .setTimestamp();

                return await interaction.reply({ embeds: [errorEmbed], ephemeral: true });
            }

            let targetMember = null;
            try {
                targetMember = await interaction.guild.members.fetch(targetUser.id);
            } catch (error) {
                const errorEmbed = new EmbedBuilder()
                    .setColor(0xff6600)
                    .setTitle('❌ Hata')
                    .setDescription('Bu kullanıcı sunucuda bulunamadı!')
                    .setTimestamp();

                return await interaction.reply({ embeds: [errorEmbed], ephemeral: true });
            }

            const botMember = interaction.guild.members.me;
            if (targetMember.roles.highest.position >= botMember.roles.highest.position) {
                const errorEmbed = new EmbedBuilder()
                    .setColor(0xff6600)
                    .setTitle('❌ Yetki Hatası')
                    .setDescription('Bu kullanıcıyı atamam! Kullanıcının rolü benim rolümden yüksek veya eşit.')
                    .setTimestamp();

                return await interaction.reply({ embeds: [errorEmbed], ephemeral: true });
            }

            if (targetMember.roles.highest.position >= interaction.member.roles.highest.position && 
                !interaction.member.permissions.has(PermissionFlagsBits.Administrator)) {
                const errorEmbed = new EmbedBuilder()
                    .setColor(0xff6600)
                    .setTitle('❌ Yetki Hatası')
                    .setDescription('Bu kullanıcıyı atamazsınız! Kullanıcının rolü sizin rolünüzden yüksek veya eşit.')
                    .setTimestamp();

                return await interaction.reply({ embeds: [errorEmbed], ephemeral: true });
            }

            if (targetMember.id === interaction.guild.ownerId) {
                const errorEmbed = new EmbedBuilder()
                    .setColor(0xff6600)
                    .setTitle('❌ Hata')
                    .setDescription('Sunucu sahibini atamazsınız!')
                    .setTimestamp();

                return await interaction.reply({ embeds: [errorEmbed], ephemeral: true });
            }

            await interaction.deferReply();

            try {
                const dmEmbed = new EmbedBuilder()
                    .setColor(0xff6600)
                    .setTitle('👢 Sunucudan Atıldınız')
                    .setDescription(`**${interaction.guild.name}** sunucusundan atıldınız.`)
                    .addFields(
                        {
                            name: '👮 Atan Yetkili',
                            value: `${interaction.user.tag}`,
                            inline: true
                        },
                        {
                            name: '📝 Sebep',
                            value: reason,
                            inline: true
                        },
                        {
                            name: '🕐 Tarih',
                            value: `<t:${Math.floor(Date.now() / 1000)}:F>`,
                            inline: false
                        },
                        {
                            name: '🔗 Tekrar Katılım',
                            value: 'Davet linki ile tekrar sunucuya katılabilirsiniz.',
                            inline: false
                        }
                    )
                    .setThumbnail(interaction.guild.iconURL({ dynamic: true }))
                    .setTimestamp();

                await targetUser.send({ embeds: [dmEmbed] });
            } catch (error) {
            }

            await targetMember.kick(`${reason} | Atan: ${interaction.user.tag}`);

            const successEmbed = new EmbedBuilder()
                .setColor(0xff6600)
                .setTitle('👢 Kullanıcı Atıldı')
                .setDescription(`**${targetUser.tag}** başarıyla sunucudan atıldı.`)
                .addFields(
                    {
                        name: '👤 Atılan Kullanıcı',
                        value: `${targetUser.tag} (${targetUser.id})`,
                        inline: true
                    },
                    {
                        name: '👮 Atan Yetkili',
                        value: `${interaction.user.tag}`,
                        inline: true
                    },
                    {
                        name: '📝 Sebep',
                        value: reason,
                        inline: false
                    },
                    {
                        name: '🔗 Not',
                        value: 'Kullanıcı davet linki ile tekrar sunucuya katılabilir.',
                        inline: false
                    }
                )
                .setThumbnail(targetUser.displayAvatarURL({ dynamic: true }))
                .setTimestamp();

            await interaction.editReply({ embeds: [successEmbed] });
        } catch (error) {
            console.error('Kick komutunda hata:', error);
            
            const errorEmbed = new EmbedBuilder()
                .setColor(0xff6600)
                .setTitle('❌ Hata')
                .setDescription('Kullanıcı atılırken bir hata oluştu!')
                .addFields({
                    name: '🔍 Olası Sebepler',
                    value: '• Bot yetkisi yetersiz olabilir\n• Kullanıcı bulunamadı\n• Bilinmeyen bir hata oluştu'
                })
                .setTimestamp();

            if (interaction.deferred) {
                await interaction.editReply({ embeds: [errorEmbed] });
            } else {
                await interaction.reply({ embeds: [errorEmbed], ephemeral: true });
            }
        }
    }
};