const { SlashCommandBuilder, EmbedBuilder, PermissionFlagsBits, ChannelType } = require('discord.js');
const { checkPermission } = require('./yetkiayarla');
const fs = require('fs');
const path = require('path');

module.exports = {
    data: new SlashCommandBuilder()
        .setName('icisim')
        .setDescription('IC İsim sistemini yönetir')
        .addSubcommand(subcommand =>
            subcommand
                .setName('ayarla')
                .setDescription('IC İsim kanalını ayarlar')
                .addChannelOption(option =>
                    option.setName('kanal')
                        .setDescription('IC İsim taleplerinin gönderileceği kanal')
                        .setRequired(true)
                        .addChannelTypes(ChannelType.GuildText))),

    async execute(interaction) {
        try {
            if (!checkPermission(interaction, 'icisimayarla')) {
                const errorEmbed = new EmbedBuilder()
                    .setColor(0xff0000)
                    .setTitle('❌ Yetkisiz Erişim')
                    .setDescription('Bu komutu kullanmak için IC İsim Ayarlama yetkisine sahip olmalısınız!')
                    .setTimestamp();

                return await interaction.reply({ embeds: [errorEmbed], ephemeral: true });
            }

            await interaction.deferReply();

            const subcommand = interaction.options.getSubcommand();

            if (subcommand === 'ayarla') {
                const kanal = interaction.options.getChannel('kanal');

                const icisimPath = path.join(__dirname, '../icisimSistemi.json');
                let icisimData = {};

                if (fs.existsSync(icisimPath)) {
                    icisimData = JSON.parse(fs.readFileSync(icisimPath, 'utf8'));
                }

                if (!icisimData[interaction.guild.id]) {
                    icisimData[interaction.guild.id] = {};
                }

                icisimData[interaction.guild.id].kanalId = kanal.id;
                icisimData[interaction.guild.id].aktif = true;

                fs.writeFileSync(icisimPath, JSON.stringify(icisimData, null, 2));

                const successEmbed = new EmbedBuilder()
                    .setColor(0x00ff00)
                    .setTitle('✅ IC İsim Sistemi Ayarlandı')
                    .setDescription('IC İsim sistemi başarıyla yapılandırıldı!')
                    .addFields({
                        name: '📺 Kanal',
                        value: `${kanal} (<#${kanal.id}>)`,
                        inline: true
                    })
                    .addFields({
                        name: '👮 Ayarlayan',
                        value: `${interaction.user} (${interaction.user.id})`,
                        inline: true
                    })
                    .setFooter({ text: 'RoveBot\'s • IC İsim Sistemi' })
                    .setTimestamp();

                await interaction.editReply({ embeds: [successEmbed] });

                // Log gönder
                try {
                    const configPath = path.join(__dirname, '../../config.json');
                    const config = JSON.parse(fs.readFileSync(configPath, 'utf8'));
                    
                    if (config.LogSistemi.aktif && config.LogSistemi.logKanallari.icisimAyarlaLog) {
                        const logChannel = interaction.guild.channels.cache.get(config.LogSistemi.logKanallari.icisimAyarlaLog);
                        if (logChannel) {
                            const logEmbed = new EmbedBuilder()
                                .setColor(0x0099ff)
                                .setTitle('📝 IC İsim Sistemi Ayarlandı')
                                .setDescription('IC İsim sistemi yapılandırıldı')
                                .addFields({
                                    name: '👮 İşlem Yapan',
                                    value: `${interaction.user} (${interaction.user.id})`,
                                    inline: true
                                })
                                .addFields({
                                    name: '📺 Kanal',
                                    value: `${kanal} (<#${kanal.id}>)`,
                                    inline: true
                                })
                                .setFooter({ text: 'RoveBot\'s ✨ Log Sistemi' })
                                .setTimestamp();

                            await logChannel.send({ embeds: [logEmbed] });
                        }
                    }
                } catch (logError) {
                    console.error('Log gönderme hatası:', logError);
                }
            }

        } catch (error) {
            console.error('IC İsim komutu hatası:', error);
            
            const errorEmbed = new EmbedBuilder()
                .setColor(0xff0000)
                .setTitle('❌ Sistem Hatası')
                .setDescription('IC İsim işlemi sırasında bir hata oluştu!')
                .setTimestamp();

            if (interaction.deferred) {
                await interaction.editReply({ embeds: [errorEmbed] });
            } else {
                await interaction.reply({ embeds: [errorEmbed], ephemeral: true });
            }
        }
    }
}