const { SlashCommandBuilder, EmbedBuilder, ChannelType } = require('discord.js');
const fs = require('fs');
const path = require('path');
const { checkPermission } = require('./yetkiayarla.js');

module.exports = {
    data: new SlashCommandBuilder()
        .setName('botses')
        .setDescription('Bot ses ayarlarını yönetir')
        .addChannelOption(option =>
            option.setName('sesodasi')
                .setDescription('Botun katılacağı ses odası')
                .setRequired(true)
                .addChannelTypes(ChannelType.GuildVoice)),

    async execute(interaction) {
        try {
            // Yetki kontrolü
            if (!checkPermission(interaction, 'botses')) {
                const errorEmbed = new EmbedBuilder()
                    .setColor(0xff0000)
                    .setTitle('❌ Yetkisiz Erişim')
                    .setDescription('Bu komutu kullanmak için gerekli yetkiye sahip değilsiniz!')
                    .addFields({
                        name: '🔐 Gerekli Yetki',
                        value: 'Bot Ses Rolü yetkisi veya Administrator yetkisi',
                        inline: false
                    })
                    .setFooter({ text: `RoveBot\'s • Yetki Sistemi` })
                    .setTimestamp();

                return await interaction.reply({ embeds: [errorEmbed], ephemeral: true });
            }

            await interaction.deferReply();

            const sesOdasi = interaction.options.getChannel('sesodasi');
            
            // Bot ses ayarları dosya yolu
            const botSesPath = path.join(__dirname, '../botSesSistemi.json');
            let botSesData = {};

            // Mevcut veriyi oku
            if (fs.existsSync(botSesPath)) {
                botSesData = JSON.parse(fs.readFileSync(botSesPath, 'utf8'));
            }

            // Guild verilerini başlat
            if (!botSesData[interaction.guild.id]) {
                botSesData[interaction.guild.id] = {
                    voiceChannelId: null,
                    enabled: false
                };
            }

            // Yeni ayarları kaydet
            botSesData[interaction.guild.id].voiceChannelId = sesOdasi.id;
            botSesData[interaction.guild.id].enabled = true;

            // Dosyaya yaz
            fs.writeFileSync(botSesPath, JSON.stringify(botSesData, null, 2));

            // Botu ses odasına bağla
            try {
                const { joinVoiceChannel, VoiceConnectionStatus } = require('@discordjs/voice');
                
                const connection = joinVoiceChannel({
                    channelId: sesOdasi.id,
                    guildId: interaction.guild.id,
                    adapterCreator: interaction.guild.voiceAdapterCreator,
                    selfDeaf: true,  // Kulaklık kapalı
                    selfMute: false  // Mikrofon açık
                });

                // Bağlantı durumunu kontrol et
                connection.on(VoiceConnectionStatus.Ready, () => {
                    console.log(`Bot ${interaction.guild.name} sunucusunda ${sesOdasi.name} ses odasına katıldı.`);
                });

                const successEmbed = new EmbedBuilder()
                    .setColor(0x00ff00)
                    .setTitle('✅ Bot Ses Ayarları Güncellendi')
                    .setDescription(`Bot başarıyla **${sesOdasi.name}** ses odasına katıldı!`)
                    .addFields(
                        {
                            name: '🎵 Ses Odası',
                            value: `<#${sesOdasi.id}>`,
                            inline: true
                        },
                        {
                            name: '🎤 Mikrofon',
                            value: '🟢 Açık',
                            inline: true
                        },
                        {
                            name: '🎧 Kulaklık',
                            value: '🔴 Kapalı',
                            inline: true
                        },
                        {
                            name: '📋 Not',
                            value: 'Bot yeniden başlatıldığında otomatik olarak bu ses odasına katılacak.',
                            inline: false
                        }
                    )
                    .setFooter({ text: `RoveBot\'s • Bot Ses Sistemi` })
                    .setTimestamp();

                await interaction.editReply({ embeds: [successEmbed] });

            } catch (voiceError) {
                console.error('Ses bağlantısı hatası:', voiceError);
                
                const errorEmbed = new EmbedBuilder()
                    .setColor(0xff9900)
                    .setTitle('⚠️ Kısmi Başarı')
                    .setDescription('Ayarlar kaydedildi ancak ses odasına bağlanırken bir hata oluştu.')
                    .addFields(
                        {
                            name: '🎵 Kaydedilen Ses Odası',
                            value: `<#${sesOdasi.id}>`,
                            inline: true
                        },
                        {
                            name: '❌ Hata',
                            value: 'Ses odasına şu anda bağlanılamıyor. Bot yeniden başlatıldığında tekrar denenecek.',
                            inline: false
                        }
                    )
                    .setFooter({ text: `RoveBot\'s • Bot Ses Sistemi` })
                    .setTimestamp();

                await interaction.editReply({ embeds: [errorEmbed] });
            }

        } catch (error) {
            console.error('Bot ses komutunda hata:', error);
            
            const errorEmbed = new EmbedBuilder()
                .setColor(0xff0000)
                .setTitle('❌ Sistem Hatası')
                .setDescription('Bot ses ayarları güncellenirken bir hata oluştu!')
                .setTimestamp();

            if (interaction.deferred) {
                await interaction.editReply({ embeds: [errorEmbed] });
            } else {
                await interaction.reply({ embeds: [errorEmbed], ephemeral: true });
            }
        }
    }
};