const { SlashCommandBuilder, EmbedBuilder, ActionRowBuilder, ButtonBuilder, ButtonStyle } = require('discord.js');

module.exports = {
    data: new SlashCommandBuilder()
        .setName('avatar')
        .setDescription('Kullanıcının avatar ve banner bilgilerini gösterir')
        .addUserOption(option =>
            option.setName('kisi')
                .setDescription('Avatar bilgilerini görmek istediğiniz kullanıcı')
                .setRequired(true)),

    async execute(interaction) {
        try {
            const user = interaction.options.getUser('kisi');
            
            const fetchedUser = await user.fetch();
            
            const avatarURL = fetchedUser.displayAvatarURL({ 
                dynamic: true, 
                size: 4096 
            });
            
            const bannerURL = fetchedUser.bannerURL({ 
                dynamic: true, 
                size: 4096 
            });

            const avatarEmbed = new EmbedBuilder()
                .setTitle('👤 Kullanıcı Avatarı')
                .setDescription(`**Kullanıcı:** ${user}\n**ID:** \`${user.id}\`\n**Kullanıcı Adı:** ${user.username}`)
                .setThumbnail(avatarURL)
                .setColor('#0099ff')
                .setTimestamp()
                .setFooter({ 
                    text: `${interaction.user.username} tarafından istendi`, 
                    iconURL: interaction.user.displayAvatarURL({ dynamic: true }) 
                });

            if (bannerURL) {
                avatarEmbed.setImage(bannerURL);
                avatarEmbed.addFields({
                    name: '🖼️ Banner',
                    value: 'Kullanıcının banner\'ı mevcut',
                    inline: true
                });
            } else {
                avatarEmbed.addFields({
                    name: '🖼️ Banner',
                    value: 'Banner mevcut değil',
                    inline: true
                });
            }

            avatarEmbed.addFields({
                name: '📸 Avatar',
                value: 'Profil fotoğrafı mevcut',
                inline: true
            });

            const buttons = new ActionRowBuilder()
                .addComponents(
                    new ButtonBuilder()
                        .setCustomId(`download_avatar_${user.id}`)
                        .setLabel('Profil Fotoğrafını İndir')
                        .setStyle(ButtonStyle.Primary)
                        .setEmoji('📸'),
                    new ButtonBuilder()
                        .setCustomId(`download_banner_${user.id}`)
                        .setLabel('Banner\'ı İndir')
                        .setStyle(ButtonStyle.Secondary)
                        .setEmoji('🖼️')
                        .setDisabled(!bannerURL),
                    new ButtonBuilder()
                        .setCustomId(`download_both_${user.id}`)
                        .setLabel('Her İkisini İndir')
                        .setStyle(ButtonStyle.Success)
                        .setEmoji('💾')
                        .setDisabled(!bannerURL)
                );

            await interaction.reply({
                embeds: [avatarEmbed],
                components: [buttons]
            });

        } catch (error) {
            console.error('Avatar komutu hatası:', error);
            
            const errorEmbed = new EmbedBuilder()
                .setTitle('❌ Hata Oluştu')
                .setDescription(`Avatar bilgileri alınırken bir hata oluştu:\n\`\`\`${error.message}\`\`\``)
                .setColor('#ff0000')
                .setTimestamp();

            if (interaction.replied || interaction.deferred) {
                await interaction.editReply({ embeds: [errorEmbed] });
            } else {
                await interaction.reply({ embeds: [errorEmbed], ephemeral: true });
            }
        }
    }
};