# ICManager API Documentation

## Base URL
```
http://localhost:5634/api
```

## Authentication
All endpoints require Bearer token authentication:
```
Authorization: Bearer {your-token}
```

---

## Endpoints

### 1. Status Check
**GET** `/status`

Check API server status.

**Response:**
```json
{
  "status": "online",
  "server": "ICManager",
  "timestamp": "2025-01-15T10:30:00.000Z"
}
```

**Status Codes:**
- `200` - Success

---

### 2. Get All Players from Database
**GET** `/server/players/db/list`

Get list of all players from database.

**Response:**
```json
{
  "success": true,
  "count": 150,
  "players": [
    {
      "citizenid": "ABC123",
      "license": "license:abc123",
      "name": "John Doe",
      ...
    }
  ]
}
```

**Error Response:**
```json
{
  "success": false,
  "error": "Failed to fetch players from database",
  "message": "Error details"
}
```

**Status Codes:**
- `200` - Success
- `500` - Server error

---

### 3. Set Player Money
**POST** `/server/player/setmoney`

Set player's money to a specific amount.

**Request Body:**
```json
{
  "playerId": 1,
  "moneyType": "cash",
  "amount": 5000
}
```

**Parameters:**
- `playerId` (required, number) - Player's server ID
- `moneyType` (required, string) - Must be `"cash"` or `"bank"`
- `amount` (required, number) - Amount to set

**Response:**
```json
{
  "success": true,
  "result": {
    "success": true,
    "message": "Money set successfully"
  }
}
```

**Error Responses:**

Missing parameters:
```json
{
  "success": false,
  "error": "Missing required parameters: playerId, moneyType (cash/bank), amount"
}
```

Invalid moneyType:
```json
{
  "success": false,
  "error": "moneyType must be either \"cash\" or \"bank\""
}
```

Player not found:
```json
{
  "success": false,
  "error": "Player not found"
}
```

**Status Codes:**
- `200` - Success
- `400` - Bad request (missing/invalid parameters)
- `500` - Server error

---

### 4. Add Player Money
**POST** `/server/player/addmoney`

Add money to player's account.

**Request Body:**
```json
{
  "playerId": 1,
  "moneyType": "bank",
  "amount": 1000
}
```

**Parameters:**
- `playerId` (required, number) - Player's server ID
- `moneyType` (required, string) - Must be `"cash"` or `"bank"`
- `amount` (required, number) - Amount to add

**Response:**
```json
{
  "success": true,
  "result": {
    "success": true,
    "message": "Money added successfully"
  }
}
```

**Error Responses:**
Same as Set Player Money endpoint.

**Status Codes:**
- `200` - Success
- `400` - Bad request
- `500` - Server error

---

### 5. Remove Player Money
**POST** `/server/player/removemoney`

Remove money from player's account.

**Request Body:**
```json
{
  "playerId": 1,
  "moneyType": "cash",
  "amount": 500
}
```

**Parameters:**
- `playerId` (required, number) - Player's server ID
- `moneyType` (required, string) - Must be `"cash"` or `"bank"`
- `amount` (required, number) - Amount to remove

**Response:**
```json
{
  "success": true,
  "result": {
    "success": true,
    "message": "Money removed successfully"
  }
}
```

**Error Responses:**
Same as Set Player Money endpoint.

**Status Codes:**
- `200` - Success
- `400` - Bad request
- `500` - Server error

---

### 6. Add Player Item
**POST** `/server/player/additem`

Add item to player's inventory.

**Request Body:**
```json
{
  "playerId": 1,
  "item": "bread",
  "itemCount": 5
}
```

**Parameters:**
- `playerId` (required, number) - Player's server ID
- `item` (required, string) - Item name
- `itemCount` (optional, number) - Item count (default: 1)

**Response:**
```json
{
  "success": true,
  "result": {
    "success": true,
    "message": "Item added successfully"
  }
}
```

**Error Responses:**

Missing parameters:
```json
{
  "success": false,
  "error": "Missing required parameters: playerId, item"
}
```

**Status Codes:**
- `200` - Success
- `400` - Bad request
- `500` - Server error

---

### 7. Remove Player Item
**POST** `/server/player/removeitem`

Remove item from player's inventory.

**Request Body:**
```json
{
  "playerId": 1,
  "item": "bread",
  "itemCount": 2
}
```

**Parameters:**
- `playerId` (required, number) - Player's server ID
- `item` (required, string) - Item name
- `itemCount` (optional, number) - Item count to remove (default: 1)

**Response:**
```json
{
  "success": true,
  "result": {
    "success": true,
    "message": "Item removed successfully"
  }
}
```

**Error Responses:**
Same as Add Player Item endpoint.

**Status Codes:**
- `200` - Success
- `400` - Bad request
- `500` - Server error

---

### 8. Revive Player
**POST** `/server/player/revive`

Revive a dead player.

**Request Body:**
```json
{
  "playerId": 1
}
```

**Parameters:**
- `playerId` (required, number) - Player's server ID

**Response:**
```json
{
  "success": true,
  "result": {
    "success": true,
    "message": "Player revived successfully"
  }
}
```

**Error Responses:**

Missing parameter:
```json
{
  "success": false,
  "error": "Missing required parameter: playerId"
}
```

**Status Codes:**
- `200` - Success
- `400` - Bad request
- `500` - Server error

---

### 9. Kill Player
**POST** `/server/player/kill`

Kill a player.

**Request Body:**
```json
{
  "playerId": 1
}
```

**Parameters:**
- `playerId` (required, number) - Player's server ID

**Response:**
```json
{
  "success": true,
  "result": {
    "success": true,
    "message": "Player killed successfully"
  }
}
```

**Error Responses:**
Same as Revive Player endpoint.

**Status Codes:**
- `200` - Success
- `400` - Bad request
- `500` - Server error

---

### 10. Set Player Job
**POST** `/server/player/setjob`

Set player's job and grade.

**Request Body:**
```json
{
  "playerId": 1,
  "jobName": "police",
  "jobGrade": 2
}
```

**Parameters:**
- `playerId` (required, number) - Player's server ID
- `jobName` (required, string) - Job name (e.g., "police", "ambulance")
- `jobGrade` (required, number) - Job grade level

**Response:**
```json
{
  "success": true,
  "result": {
    "success": true,
    "message": "Job set successfully",
    "job": "police",
    "grade": 2
  }
}
```

**Error Responses:**

Missing parameters:
```json
{
  "success": false,
  "error": "Missing required parameters: playerId, jobName, jobGrade"
}
```

**Status Codes:**
- `200` - Success
- `400` - Bad request
- `500` - Server error

---

### 11. Give Vehicle to Player
**POST** `/server/player/givevehicle`

Give a vehicle to a player.

**Request Body:**
```json
{
  "playerId": 1,
  "carName": "adder",
  "plate": "CUSTOM01",
  "fullmod": true,
  "renk1": "255 0 0",
  "renk2": "0 255 0"
}
```

**Parameters:**
- `playerId` (required, number) - Player's server ID
- `carName` (required, string) - Vehicle model name
- `plate` (optional, string) - Custom license plate (auto-generated if not provided)
- `fullmod` (optional, boolean) - Apply full vehicle modifications (default: false)
- `renk1` or `color1` (optional, string) - Primary color in format "R G B" (default: "0 0 0")
- `renk2` or `color2` (optional, string) - Secondary color in format "R G B" (default: "0 0 0")

**Response:**
```json
{
  "success": true,
  "result": {
    "success": true,
    "plate": "CUSTOM01",
    "vehicle": "adder"
  }
}
```

**Error Responses:**

Missing parameters:
```json
{
  "success": false,
  "error": "Missing required parameters: playerId, carName"
}
```

Plate already exists:
```json
{
  "success": false,
  "error": "This plate already exists!"
}
```

**Status Codes:**
- `200` - Success
- `400` - Bad request
- `500` - Server error

---

### 12. Get Player Inventory
**GET** `/server/player/inventory?playerId=1`

Get player's inventory items.

**Query Parameters:**
- `playerId` (required, number) - Player's server ID

**Response:**
```json
{
  "success": true,
  "inventory": [
    {
      "name": "bread",
      "label": "Bread",
      "count": 5,
      "item": "bread",
      "description": "A loaf of bread"
    }
  ]
}
```

**Error Responses:**

Missing parameter:
```json
{
  "success": false,
  "error": "Missing required parameter: playerId"
}
```

**Status Codes:**
- `200` - Success
- `400` - Bad request
- `500` - Server error

---

### 13. Get Player Info
**GET** `/server/player/info?playerId=1`

Get player's basic information (name, job, money, identifiers).

**Query Parameters:**
- `playerId` (required, number) - Player's server ID

**Response:**
```json
{
  "success": true,
  "playerInfo": {
    "firstName": "John",
    "lastName": "Doe",
    "fullName": "John Doe",
    "job": {
      "name": "police",
      "label": "Law Enforcement",
      "grade": 2,
      "gradeLabel": "Sergeant"
    },
    "money": {
      "cash": 5000,
      "bank": 25000
    },
    "identifiers": [
      "license:abc123def456",
      "discord:123456789012345678",
      "steam:110000123456789",
      "ip:192.168.1.1"
    ]
  }
}
```

**Error Responses:**

Missing parameter:
```json
{
  "success": false,
  "error": "Missing required parameter: playerId"
}
```

Player not found:
```json
{
  "success": false,
  "error": "Player not found"
}
```

**Status Codes:**
- `200` - Success
- `400` - Bad request
- `500` - Server error

---

### 14. Add to Whitelist
**POST** `/server/player/addwhitelist`

Add a Discord ID to the whitelist.

**Request Body:**
```json
{
  "discordId": "123456789012345678",
  "addedBy": "admin"
}
```

**Parameters:**
- `discordId` (required, string) - Discord user ID
- `addedBy` (required, string) - Username of person adding to whitelist

**Response:**
```json
{
  "success": true,
  "result": {
    "success": true,
    "message": "Added to whitelist",
    "discordId": "123456789012345678"
  }
}
```

**Error Responses:**

Missing parameters:
```json
{
  "success": false,
  "error": "Missing required parameters: discordId, addedBy"
}
```

Already whitelisted:
```json
{
  "success": false,
  "error": "Discord ID already whitelisted"
}
```

**Status Codes:**
- `200` - Success
- `400` - Bad request
- `500` - Server error

---

### 15. Remove from Whitelist
**POST** `/server/player/removewhitelist`

Remove a Discord ID from the whitelist.

**Request Body:**
```json
{
  "discordId": "123456789012345678",
  "removedBy": "admin"
}
```

**Parameters:**
- `discordId` (required, string) - Discord user ID
- `removedBy` (required, string) - Username of person removing from whitelist

**Response:**
```json
{
  "success": true,
  "result": {
    "success": true,
    "message": "Removed from whitelist",
    "discordId": "123456789012345678"
  }
}
```

**Error Responses:**

Missing parameters:
```json
{
  "success": false,
  "error": "Missing required parameters: discordId, removedBy"
}
```

Not found:
```json
{
  "success": false,
  "error": "Discord ID not found in whitelist"
}
```

**Status Codes:**
- `200` - Success
- `400` - Bad request
- `500` - Server error

---

### 16. Get Whitelist Info
**GET** `/server/player/whitelistinfo?discordId=123456789012345678`

Get whitelist information for a Discord ID.

**Query Parameters:**
- `discordId` (required, string) - Discord user ID

**Response:**
```json
{
  "success": true,
  "whitelistInfo": {
    "discordId": "123456789012345678",
    "addedBy": "admin",
    "addedAt": "2025-01-15T10:30:00.000Z"
  }
}
```

**Error Responses:**

Missing parameter:
```json
{
  "success": false,
  "error": "Missing required parameter: discordId"
}
```

Not found:
```json
{
  "success": false,
  "error": "Discord ID not found in whitelist"
}
```

**Status Codes:**
- `200` - Success
- `400` - Bad request
- `500` - Server error

---

### 17. Ban Player
**POST** `/server/player/ban`

Ban a player by Discord ID. If the player is currently online, they will be kicked from the server with a ban message.

**Request Body:**
```json
{
  "discordId": "123456789012345678",
  "banReason": "Hile kullanımı",
  "banDuration": "7 Day",
  "bannedBy": "admin"
}
```

**Parameters:**
- `discordId` (required, string) - Discord user ID
- `banReason` (required, string) - Reason for ban
- `banDuration` (required, string) - Ban duration. Must be one of:
  - `"1 Day"`
  - `"3 Day"`
  - `"7 Day"`
  - `"1 Month"`
  - `"Permanent"`
- `bannedBy` (required, string) - Username of person banning

**Response:**
```json
{
  "success": true,
  "result": {
    "success": true,
    "message": "Player banned successfully",
    "discordId": "123456789012345678"
  }
}
```

**Note:** If the player is online when banned, they will be immediately kicked with a message showing:
- Ban reason
- Ban duration (or "Kalıcı" for permanent)
- Remaining time (if not permanent)
- Who banned them

**Error Responses:**

Missing parameters:
```json
{
  "success": false,
  "error": "Missing required parameters: discordId, banReason, banDuration, bannedBy"
}
```

Invalid ban duration:
```json
{
  "success": false,
  "error": "Invalid banDuration. Must be one of: 1 Day, 3 Day, 7 Day, 1 Month, Permanent"
}
```

Already banned:
```json
{
  "success": false,
  "error": "Discord ID already banned"
}
```

**Status Codes:**
- `200` - Success
- `400` - Bad request
- `500` - Server error

---

### 18. Unban Player
**POST** `/server/player/unban`

Unban a player by Discord ID.

**Request Body:**
```json
{
  "discordId": "123456789012345678",
  "unbanReason": "Yanlış ban",
  "unbannedBy": "admin"
}
```

**Parameters:**
- `discordId` (required, string) - Discord user ID
- `unbanReason` (required, string) - Reason for unban
- `unbannedBy` (required, string) - Username of person unbanning

**Response:**
```json
{
  "success": true,
  "result": {
    "success": true,
    "message": "Player unbanned successfully",
    "discordId": "123456789012345678"
  }
}
```

**Error Responses:**

Missing parameters:
```json
{
  "success": false,
  "error": "Missing required parameters: discordId, unbanReason, unbannedBy"
}
```

Not found or already unbanned:
```json
{
  "success": false,
  "error": "Discord ID not found in bans or already unbanned"
}
```

**Status Codes:**
- `200` - Success
- `400` - Bad request
- `500` - Server error

---

### 19. Get Ban Info
**GET** `/server/player/baninfo?discordId=123456789012345678`

Get ban information for a Discord ID.

**Query Parameters:**
- `discordId` (required, string) - Discord user ID

**Response:**
```json
{
  "success": true,
  "banInfo": {
    "discordId": "123456789012345678",
    "banReason": "Hile kullanımı",
    "banDuration": "7 Day",
    "bannedAt": "2025-01-15T10:30:00.000Z",
    "bannedBy": "admin",
    "expiresAt": 1737129600,
    "isUnbanned": false,
    "unbannedAt": null,
    "unbanReason": null,
    "unbannedBy": null,
    "remainingTime": "6 gün, 23 saat, 58 dakika",
    "isExpired": false
  }
}
```

**Note:** 
- `remainingTime` and `isExpired` are only present if the ban is active and not permanent
- `remainingTime` format: "X gün, Y saat, Z dakika" (Turkish)
- For permanent bans, `expiresAt` is `null` and `remainingTime` is `"Kalıcı"`

**Error Responses:**

Missing parameter:
```json
{
  "success": false,
  "error": "Missing required parameter: discordId"
}
```

Not found:
```json
{
  "success": false,
  "error": "Discord ID not found in bans"
}
```

**Status Codes:**
- `200` - Success
- `400` - Bad request
- `500` - Server error

---

## Common Error Responses

### 400 Bad Request
```json
{
  "success": false,
  "error": "Error message describing what went wrong"
}
```

### 500 Internal Server Error
```json
{
  "success": false,
  "error": "Error message"
}
```

---

## Notes

1. **Player ID**: All `playerId` parameters refer to the FiveM server player ID (source), not the database citizen ID.

2. **Ban System**: 
   - Bans are automatically checked when players connect
   - Expired bans are automatically removed
   - Permanent bans have `expiresAt` as `null`
   - **If a player is online when banned, they will be immediately kicked from the server with a ban message**

3. **Whitelist System**: 
   - Players must be whitelisted to join the server
   - Whitelist is checked on player connection

4. **Money Types**: 
   - `cash` - Physical cash
   - `bank` - Bank account balance

5. **Vehicle Colors**: 
   - Color format: `"R G B"` (e.g., `"255 0 0"` for red)
   - Both `renk1/renk2` and `color1/color2` parameter names are supported

6. **Identifiers**: 
   - The `/server/player/info` endpoint returns all player identifiers including:
     - `license:` - FiveM license identifier
     - `discord:` - Discord user ID
     - `steam:` - Steam ID (if available)
     - `ip:` - IP address
     - Other identifiers as available

7. **Authentication**: 
   - All endpoints require Bearer token authentication
   - Token should be included in the `Authorization` header

---

## Example cURL Requests

### Get Player Info
```bash
curl -H "Authorization: Bearer your-token" \
  http://localhost:5634/api/server/player/info?playerId=1
```

### Ban Player
```bash
curl -X POST \
  -H "Authorization: Bearer your-token" \
  -H "Content-Type: application/json" \
  -d '{
    "discordId": "123456789012345678",
    "banReason": "Hile kullanımı",
    "banDuration": "7 Day",
    "bannedBy": "admin"
  }' \
  http://localhost:5634/api/server/player/ban
```

### Give Vehicle
```bash
curl -X POST \
  -H "Authorization: Bearer your-token" \
  -H "Content-Type: application/json" \
  -d '{
    "playerId": 1,
    "carName": "adder",
    "fullmod": true,
    "renk1": "255 0 0",
    "renk2": "0 255 0"
  }' \
  http://localhost:5634/api/server/player/givevehicle
```

### Add to Whitelist
```bash
curl -X POST \
  -H "Authorization: Bearer your-token" \
  -H "Content-Type: application/json" \
  -d '{
    "discordId": "123456789012345678",
    "addedBy": "admin"
  }' \
  http://localhost:5634/api/server/player/addwhitelist
```

---

## Version
API Version: 1.0.0
Last Updated: 2025-01-15

